/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.ColLogIcon;
import com.example.LogLockedConfig;
import com.example.LogLockedOverlay;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.IconID;
import net.runelite.api.IndexedSprite;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.SpritePixels;
import net.runelite.api.events.BeforeRender;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="LogLocked", description="Plugin that allows users to unlock Col Log sections based on total log slots (10slots = 1section)- Made for Dabe", tags={"LogLocked,ColLog,Dabe"})
public class LogLocked
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LogLocked.class);
    @Inject
    private Client client;
    @Inject
    private LogLockedConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private LogLockedOverlay overlay;
    @Inject
    private ClientThread clientThread;
    private static final Pattern COLLECTION_LOG_ITEM_REGEX = Pattern.compile("New item added to your collection log:.*");
    private final HashMap<ColLogIcon, Integer> iconIds = new HashMap();
    private final List<String> validEntries = new ArrayList<String>();
    private ColLogIcon selectedIcon = null;
    int totalLogSlots;
    int bankedSlots = 0;
    int slotsTillNext;
    public List<String> unlockedSlots;

    protected void startUp() throws Exception {
        this.unlockedSlots = new ArrayList<String>(List.of(this.config.unlockedLogs().split(",")));
        this.updateSelectedIcon();
        this.bankedSlots = Integer.parseInt(this.config.storedInfo().split("/")[0]);
        this.slotsTillNext = Integer.parseInt(this.config.storedInfo().split("/")[1]);
        if (this.client.getModIcons() == null) {
            this.iconIds.clear();
            return;
        }
        this.loadSprites();
        this.overlayManager.add((Overlay)this.overlay);
        log.info("LogLocked started");
    }

    protected void shutDown() throws Exception {
        this.iconIds.clear();
        this.clientThread.invoke(() -> this.client.runScript(new Object[]{223}));
        this.configManager.setConfiguration("LogLocked", "stored_info", this.bankedSlots + "/" + this.slotsTillNext);
        this.overlayManager.remove((Overlay)this.overlay);
        log.info("LogLocked stopped");
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("LogLocked") && event.getKey().equals("icon")) {
            this.updateSelectedIcon();
            this.clientThread.invoke(this::updateChatbox);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() == ChatMessageType.GAMEMESSAGE && COLLECTION_LOG_ITEM_REGEX.matcher(event.getMessage()).matches()) {
            ++this.totalLogSlots;
            this.bankedSlots = this.totalLogSlots / 10 + this.config.additionalSlots() - (this.unlockedSlots.size() - 1);
            this.slotsTillNext = this.calcSlotsTillNext(this.totalLogSlots);
            this.configManager.setConfiguration("LogLocked", "stored_info", this.bankedSlots + "/" + this.slotsTillNext);
        }
        if (event.getName() == null || this.client.getLocalPlayer() == null || this.client.getLocalPlayer().getName() == null) {
            return;
        }
        boolean isLocalPlayer = Text.standardize((String)event.getName()).equalsIgnoreCase(Text.standardize((String)this.client.getLocalPlayer().getName()));
        if (isLocalPlayer) {
            event.getMessageNode().setName(this.getImgTag(this.iconIds.getOrDefault((Object)this.selectedIcon, IconID.NO_ENTRY.getIndex())) + Text.removeTags((String)event.getName()));
        }
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if (!event.getEventName().equals("setChatboxInput")) {
            return;
        }
        this.updateChatbox();
    }

    @Subscribe
    public void onBeforeRender(BeforeRender event) {
        this.updateChatbox();
        Widget colLogEntryHeader = this.client.getWidget(WidgetInfo.COLLECTION_LOG_ENTRY_HEADER);
        Widget colLogEntryList = this.client.getWidget(621, 34);
        if (colLogEntryHeader != null) {
            int i = 0;
            while (colLogEntryList.isHidden() && i < 5) {
                switch (++i) {
                    case 1: {
                        colLogEntryList = this.client.getWidget(621, 12);
                        break;
                    }
                    case 2: {
                        colLogEntryList = this.client.getWidget(621, 16);
                        break;
                    }
                    case 3: {
                        colLogEntryList = this.client.getWidget(621, 32);
                        break;
                    }
                    case 4: {
                        colLogEntryList = this.client.getWidget(621, 34);
                        break;
                    }
                    case 5: {
                        colLogEntryList = this.client.getWidget(621, 35);
                    }
                }
            }
        }
        if (colLogEntryHeader != null && !colLogEntryList.isHidden()) {
            for (Widget widget : colLogEntryList.getDynamicChildren()) {
                this.validEntries.add(widget.getText());
                if (!this.unlockedSlots.contains(widget.getText())) {
                    widget.setTextColor(Color.GRAY.getRGB());
                    continue;
                }
                if (widget.getTextColor() == 901389 || !this.unlockedSlots.contains(widget.getText())) continue;
                widget.setTextColor(new Color(255, 152, 31).getRGB());
            }
        }
        if (colLogEntryHeader != null) {
            Widget colLogEntry = this.client.getWidget(WidgetInfo.COLLECTION_LOG_ENTRY);
            String openedLogName = colLogEntryHeader.getChild(0).getText();
            colLogEntry.setHidden(!this.unlockedSlots.contains(openedLogName));
            colLogEntry.revalidate();
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        Widget colLogTitleWig = this.client.getWidget(621, 1);
        if (colLogTitleWig != null) {
            colLogTitleWig = colLogTitleWig.getChild(1);
            this.totalLogSlots = Integer.parseInt(colLogTitleWig.getText().split("- ")[1].split("/")[0]);
            this.bankedSlots = this.totalLogSlots / 10 + this.config.additionalSlots() - (this.unlockedSlots.size() - 1);
            this.slotsTillNext = this.calcSlotsTillNext(this.totalLogSlots);
            this.configManager.setConfiguration("LogLocked", "stored_info", this.bankedSlots + "/" + this.slotsTillNext);
            colLogTitleWig.setText(colLogTitleWig.getText() + " - Banked:" + this.bankedSlots + " - Next:" + this.slotsTillNext);
            colLogTitleWig.revalidate();
        }
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        int endIdx;
        int startIdx;
        String target;
        String colLogSectionName;
        if (event.getFirstEntry().getOption().equals("Check") && !this.unlockedSlots.contains(colLogSectionName = (target = event.getFirstEntry().getTarget()).substring(startIdx = target.indexOf(62) + 1, endIdx = target.lastIndexOf(60))) && this.validEntries.contains(colLogSectionName)) {
            this.client.createMenuEntry(1).setOption("Unlock").setTarget(event.getFirstEntry().getTarget() + " Cost: 10").setType(MenuAction.RUNELITE).onClick(this::menuEntryClicked);
        }
    }

    private void menuEntryClicked(MenuEntry menuEntry) {
        if (this.bankedSlots >= 1) {
            String target = menuEntry.getTarget();
            int startIdx = target.indexOf(62) + 1;
            int endIdx = target.lastIndexOf(60);
            String colLogSectionName = target.substring(startIdx, endIdx);
            this.unlockedSlots.add(colLogSectionName);
            String updatedUnlocks = String.join((CharSequence)",", this.unlockedSlots);
            this.configManager.setConfiguration("LogLocked", "unlocked_logs", updatedUnlocks);
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Congratulations you have unlocked the " + colLogSectionName + " Collection Log section.", "", false);
            this.updateColLogHeader();
            this.configManager.setConfiguration("LogLocked", "stored_info", this.bankedSlots + "/" + this.slotsTillNext);
        } else {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "You do not have enough banked slots to unlock this Collection Log section.", "", false);
        }
    }

    public int calcSlotsTillNext(int totalLogSlots) {
        totalLogSlots = totalLogSlots % 10 == 0 ? 10 : 10 - totalLogSlots % 10;
        return totalLogSlots;
    }

    public void updateColLogHeader() {
        Widget colLogTitleWig = this.client.getWidget(621, 1);
        if (colLogTitleWig != null) {
            colLogTitleWig = colLogTitleWig.getChild(1);
            int oldBankedSlots = this.bankedSlots--;
            String header = colLogTitleWig.getText().replace("Banked:" + oldBankedSlots, "Banked:" + this.bankedSlots);
            colLogTitleWig.setText(header);
            colLogTitleWig.revalidate();
        }
    }

    private void loadSprites() {
        this.clientThread.invoke(() -> {
            IndexedSprite[] modIcons = this.client.getModIcons();
            ArrayList<IndexedSprite> newList = new ArrayList<IndexedSprite>();
            int modIconsStart = modIcons.length - 1;
            for (ColLogIcon icon : ColLogIcon.values()) {
                IndexedSprite sprite;
                BufferedImage bufferedImage = this.getSprite(3390);
                if (icon.name().equals("FADED_LOG_ICON")) {
                    bufferedImage = ImageUtil.luminanceOffset((Image)bufferedImage, (int)70);
                }
                if ((sprite = ImageUtil.getImageIndexedSprite((BufferedImage)(bufferedImage = ImageUtil.resizeImage((BufferedImage)bufferedImage, (int)13, (int)13)), (Client)this.client)) == null) continue;
                newList.add(sprite);
                this.iconIds.put(icon, ++modIconsStart);
            }
            IndexedSprite[] newAry = Arrays.copyOf(modIcons, modIcons.length + newList.size());
            System.arraycopy(newList.toArray(new IndexedSprite[0]), 0, newAry, modIcons.length, newList.size());
            this.client.setModIcons(newAry);
        });
    }

    private BufferedImage getSprite(int id) {
        return this.getPixels(id).toBufferedImage();
    }

    private SpritePixels getPixels(int archive) {
        SpritePixels[] sp = this.client.getSprites(this.client.getIndexSprites(), archive, 0);
        if (sp == null) {
            return null;
        }
        return sp[0];
    }

    private String getImgTag(int i) {
        return "<img=" + i + ">";
    }

    private void updateChatbox() {
        Widget chatboxTypedText = this.client.getWidget(WidgetInfo.CHATBOX_INPUT);
        if (this.getIconIdx() == -1) {
            return;
        }
        if (chatboxTypedText == null || chatboxTypedText.isHidden()) {
            return;
        }
        String[] chatbox = chatboxTypedText.getText().split(":", 2);
        String rsn = Objects.requireNonNull(this.client.getLocalPlayer()).getName();
        chatboxTypedText.setText(this.getImgTag(this.getIconIdx()) + Text.removeTags((String)rsn) + ":" + chatbox[1]);
    }

    private int getIconIdx() {
        if (this.selectedIcon == null) {
            this.updateSelectedIcon();
        }
        return this.iconIds.getOrDefault((Object)this.selectedIcon, IconID.NO_ENTRY.getIndex());
    }

    private void updateSelectedIcon() {
        if (this.selectedIcon != this.config.icon()) {
            this.selectedIcon = this.config.icon();
        }
    }

    @Provides
    LogLockedConfig provideConfig(ConfigManager configManager) {
        return (LogLockedConfig)configManager.getConfig(LogLockedConfig.class);
    }
}

