/*
 * Decompiled with CFR 0.152.
 */
package com.lootingbag;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import com.lootingbag.LootingBagConfig;
import com.lootingbag.LootingBagOverlay;
import com.lootingbag.PickupAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Looting Bag")
public class LootingBagPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LootingBagPlugin.class);
    public static final int LOOTING_BAG_CONTAINER = 516;
    private static final Set<Integer> FEROX_REGION = ImmutableSet.of((Object)12600, (Object)12344);
    private static final int LOOTING_BAG_SIZE = 28;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private LootingBagOverlay overlay;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    @Inject
    private LootingBagConfig config;
    private final Map<Integer, Integer> bagItems = new HashMap<Integer, Integer>();
    private int freeSlots = -1;
    private long value = -1L;
    private boolean atleast = false;
    private PickupAction lastPickUpAction;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (widgetLoaded.getGroupId() != WidgetInfo.LOOTING_BAG_CONTAINER.getGroupId()) {
            return;
        }
        this.updateValue();
    }

    private void updateValue() {
        ItemContainer itemContainer = this.client.getItemContainer(516);
        if (itemContainer == null) {
            this.value = 0L;
            this.freeSlots = 28;
            return;
        }
        long newValue = 0L;
        this.bagItems.clear();
        this.freeSlots = 28;
        for (Item item : itemContainer.getItems()) {
            if (item.getId() < 0) continue;
            this.bagItems.merge(item.getId(), item.getQuantity(), Integer::sum);
            newValue += this.getPrice(item.getId()) * (long)item.getQuantity();
            --this.freeSlots;
        }
        this.value = newValue;
        this.atleast = false;
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() != 516) {
            return;
        }
        this.updateValue();
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() != MenuAction.GROUND_ITEM_THIRD_OPTION) {
            return;
        }
        if (!event.getMenuOption().equals("Take")) {
            return;
        }
        WorldPoint point = WorldPoint.fromScene((Client)this.client, (int)event.getParam0(), (int)event.getParam1(), (int)this.client.getPlane());
        this.lastPickUpAction = new PickupAction(event.getId(), point);
    }

    @Subscribe
    public void onItemDespawned(ItemDespawned event) {
        if (this.value < 0L) {
            return;
        }
        if (this.client.getVarbitValue(5963) == 0 && !FEROX_REGION.contains(this.client.getLocalPlayer().getWorldLocation().getRegionID())) {
            return;
        }
        ItemContainer inv = this.client.getItemContainer(InventoryID.INVENTORY);
        if (inv == null || !inv.contains(22586)) {
            return;
        }
        if (this.lastPickUpAction == null) {
            return;
        }
        if (!event.getTile().getWorldLocation().equals((Object)this.client.getLocalPlayer().getWorldLocation())) {
            return;
        }
        if (!event.getTile().getWorldLocation().equals((Object)this.lastPickUpAction.getWorldPoint())) {
            return;
        }
        int itemId = event.getItem().getId();
        if (itemId != this.lastPickUpAction.getItemId()) {
            return;
        }
        ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
        if (!itemComposition.isTradeable()) {
            return;
        }
        int quantity = event.getItem().getQuantity();
        if (quantity >= 65535) {
            this.atleast = true;
        }
        this.value += this.getPrice(itemId) * (long)quantity;
        if (!this.bagItems.containsKey(itemId) || !itemComposition.isStackable()) {
            --this.freeSlots;
        }
        this.bagItems.merge(itemId, quantity, Integer::sum);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (this.value > 0L && event.getGroup().equals("runelite") && event.getKey().equals("useWikiItemPrices")) {
            this.clientThread.invokeLater(() -> {
                long newValue = 0L;
                for (Map.Entry<Integer, Integer> entry : this.bagItems.entrySet()) {
                    int itemId = entry.getKey();
                    int quantity = entry.getValue();
                    newValue += this.getPrice(itemId) * (long)quantity;
                }
                this.value = newValue;
            });
        }
    }

    public long getPrice(int itemId) {
        return this.itemManager.getItemPrice(itemId);
    }

    @Provides
    LootingBagConfig provideConfig(ConfigManager configManager) {
        return (LootingBagConfig)configManager.getConfig(LootingBagConfig.class);
    }

    public String getValueText() {
        String text;
        if (this.value < 0L) {
            return "Check";
        }
        String string = text = this.atleast ? ">" : "";
        if (this.value >= 10000000L) {
            return text + this.value / 1000000L + "M";
        }
        if (this.value >= 100000L) {
            return text + this.value / 1000L + "k";
        }
        return text + this.value;
    }

    public String getFreeSlotsText() {
        if (this.freeSlots < 0) {
            return "Check";
        }
        return Integer.toString(this.freeSlots);
    }
}

