/*
 * Decompiled with CFR 0.152.
 */
package com.lootingbag;

import com.google.inject.Inject;
import com.lootingbag.LootingBagConfig;
import com.lootingbag.LootingBagPlugin;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.components.TextComponent;

public class LootingBagOverlay
extends WidgetItemOverlay {
    private final LootingBagPlugin plugin;
    private final LootingBagConfig config;

    @Inject
    LootingBagOverlay(LootingBagPlugin plugin, LootingBagConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.showOnInventory();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem widgetItem) {
        if (itemId != 11941 && itemId != 22586) {
            return;
        }
        graphics.setFont(FontManager.getRunescapeSmallFont());
        if (this.config.bagValue()) {
            this.renderText(graphics, widgetItem.getCanvasBounds(), 0, this.plugin.getValueText());
        }
        if (this.config.freeSlots()) {
            this.renderText(graphics, widgetItem.getCanvasBounds(), -12, this.plugin.getFreeSlotsText());
        }
    }

    private void renderText(Graphics2D graphics, Rectangle bounds, int yOff, String text) {
        TextComponent textComponent = new TextComponent();
        textComponent.setPosition(new Point(bounds.x - 1, bounds.y + bounds.height - 1 + yOff));
        textComponent.setColor(this.config.textColor());
        textComponent.setText(text);
        textComponent.render(graphics);
    }
}

