/*
 * Decompiled with CFR 0.152.
 */
package com.zom;

import com.google.gson.Gson;
import com.zom.BankItemNotesManager;
import com.zom.BankItemNotesOverlay;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.widgets.WidgetUtil;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.banktags.tabs.TabInterface;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Bank Notes", description="Add Notes to items in your bank", tags={"bank,merching,merch,item,history,price,notes"})
public class BankNotesPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BankNotesPlugin.class);
    static String CONFIG_GROUP = "itemnotesplugin";
    static String CONFIG_KEY = "itemnotesjson";
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    @Inject
    Gson gson;
    @Inject
    private ClientThread clientThread;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private BankItemNotesOverlay overlay;
    boolean addEditPriceHistory = true;
    boolean showPriceHistory = true;
    @Inject
    BankItemNotesManager itemPriceHistoryManager;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.itemPriceHistoryManager.refresh();
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        int groupId = WidgetUtil.componentToInterface((int)event.getActionParam1());
        if (this.addEditPriceHistory && groupId == 12 && event.getOption().equals("Examine")) {
            String text = "Edit Item Notes";
            this.client.createMenuEntry(-1).setParam0(event.getActionParam0()).setParam1(event.getActionParam1()).setTarget(event.getTarget()).setOption(text).setType(MenuAction.RUNELITE).setIdentifier(event.getIdentifier()).onClick(this::editTags);
        }
    }

    private void editTags(MenuEntry entry) {
        int inventoryIndex = entry.getParam0();
        ItemContainer bankContainer = this.client.getItemContainer(InventoryID.BANK);
        if (bankContainer == null) {
            return;
        }
        Item[] items = bankContainer.getItems();
        if (inventoryIndex < 0 || inventoryIndex >= items.length) {
            return;
        }
        Item item = bankContainer.getItems()[inventoryIndex];
        if (item == null) {
            return;
        }
        int itemId = item.getId();
        ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
        String name = itemComposition.getName();
        String initialValue = this.itemPriceHistoryManager.getItemNote(itemId);
        this.chatboxPanelManager.openTextInput(name + ": ").addCharValidator(TabInterface.FILTERED_CHARS).value(initialValue).onDone(newValue -> this.clientThread.invoke(() -> this.itemPriceHistoryManager.addItem(itemId, (String)newValue))).build();
    }

    public boolean isShowPriceHistory() {
        return this.showPriceHistory;
    }
}

