/*
 * Decompiled with CFR 0.152.
 */
package com.zom;

import com.zom.BankItemNotesManager;
import com.zom.BankNotesPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuEntry;
import net.runelite.api.widgets.WidgetUtil;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ColorUtil;

public class BankItemNotesOverlay
extends Overlay {
    private static final int BANK_ITEM_WIDGETID = 786445;
    private final BankNotesPlugin plugin;
    private final Client client;
    private final BankItemNotesManager itemPriceHistoryManager;
    private final TooltipManager tooltipManager;

    @Inject
    BankItemNotesOverlay(BankNotesPlugin plugin, Client client, BankItemNotesManager itemPriceHistoryManager, TooltipManager tooltipManager) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.plugin = plugin;
        this.client = client;
        this.itemPriceHistoryManager = itemPriceHistoryManager;
        this.tooltipManager = tooltipManager;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isShowPriceHistory()) {
            return null;
        }
        if (this.client.isMenuOpen()) {
            return null;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int last = menuEntries.length - 1;
        if (last < 0) {
            return null;
        }
        MenuEntry menuEntry = menuEntries[last];
        int widgetId = menuEntry.getParam1();
        int groupId = WidgetUtil.componentToInterface((int)widgetId);
        this.addTooltip(menuEntry, groupId);
        return null;
    }

    private void addTooltip(MenuEntry menuEntry, int groupId) {
        String text;
        if (groupId == 12 && (text = this.makeValueTooltip(menuEntry)) != null) {
            this.tooltipManager.add(new Tooltip(ColorUtil.prependColorTag((String)text, (Color)new Color(238, 238, 238))));
        }
    }

    private String makeValueTooltip(MenuEntry menuEntry) {
        int widgetId = menuEntry.getParam1();
        ItemContainer container = null;
        if (widgetId == 786445) {
            container = this.client.getItemContainer(InventoryID.BANK);
        }
        if (container == null) {
            return null;
        }
        int index = menuEntry.getParam0();
        Item item = container.getItem(index);
        if (item == null) {
            return null;
        }
        if (!this.itemPriceHistoryManager.getItemNote(item.getId()).equals("")) {
            return "Item note(s): " + this.itemPriceHistoryManager.getItemNote(item.getId());
        }
        return null;
    }
}

