/*
 * Decompiled with CFR 0.152.
 */
package com.zom;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.zom.BankItemNote;
import com.zom.BankNotesPlugin;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BankItemNotesManager {
    private static final Logger log = LoggerFactory.getLogger(BankItemNotesManager.class);
    Client client;
    ConfigManager configManager;
    ItemClient itemClient;
    private final Gson gson;
    private static final Type typeToken = new TypeToken<List<BankItemNote>>(){}.getType();
    ArrayList<BankItemNote> itemNotesArrayList;

    @Inject
    public BankItemNotesManager(Client client, ItemClient itemClient, Gson gson, ConfigManager configManager) {
        this.configManager = configManager;
        this.client = client;
        this.itemClient = itemClient;
        this.gson = gson.newBuilder().create();
    }

    public void refresh() {
        String json = this.configManager.getConfiguration(BankNotesPlugin.CONFIG_GROUP, BankNotesPlugin.CONFIG_KEY);
        this.itemNotesArrayList = Strings.isNullOrEmpty((String)json) ? new ArrayList() : (ArrayList)this.gson.fromJson(json, typeToken);
    }

    public void addItem(int itemID, String note) {
        this.itemNotesArrayList.removeIf(i -> i.getItemid() == itemID);
        if (!note.equals("")) {
            this.itemNotesArrayList.add(new BankItemNote(itemID, note));
        }
        this.configManager.setConfiguration(BankNotesPlugin.CONFIG_GROUP, BankNotesPlugin.CONFIG_KEY, this.gson.toJson(this.itemNotesArrayList, typeToken));
    }

    public String getItemNote(int itemID) {
        Optional<BankItemNote> priceHistoryOptional = this.itemNotesArrayList.stream().filter(i -> i.getItemid() == itemID).findAny();
        if (priceHistoryOptional.isPresent()) {
            return priceHistoryOptional.get().getNote();
        }
        return "";
    }
}

