/*
 * Decompiled with CFR 0.152.
 */
package com.menuhp;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import com.menuhp.MenuHpConfig;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.NpcDespawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import net.runelite.client.util.WildcardMatcher;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Monster Menu HP", description="Show a monster's HP in its menu entry", tags={"monsters", "npcs", "hitpoints", "hp", "menu"})
public class MenuHpPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MenuHpPlugin.class);
    @Inject
    private Client client;
    @Inject
    private MenuHpConfig config;
    private static final Set<MenuAction> NPC_MENU_ACTIONS = ImmutableSet.of((Object)MenuAction.NPC_FIRST_OPTION, (Object)MenuAction.NPC_SECOND_OPTION, (Object)MenuAction.NPC_THIRD_OPTION, (Object)MenuAction.NPC_FOURTH_OPTION, (Object)MenuAction.NPC_FIFTH_OPTION, (Object)MenuAction.WIDGET_TARGET_ON_NPC, (Object[])new MenuAction[]{MenuAction.ITEM_USE_ON_NPC});
    private static final Pattern COLOR_TAG_PATTERN = Pattern.compile("<col=([a-zA-Z0-9]+)>");
    private List<String> npcNames;
    private Map<NPC, Double> npcRatios;

    @Provides
    private MenuHpConfig provideConfig(ConfigManager configManager) {
        return (MenuHpConfig)configManager.getConfig(MenuHpConfig.class);
    }

    protected void startUp() throws Exception {
        this.npcNames = Text.fromCSV((String)this.config.npcsToShow());
        this.npcRatios = new LinkedHashMap<NPC, Double>();
    }

    protected void shutDown() throws Exception {
        this.npcRatios = null;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("menuhp")) {
            this.npcNames = Text.fromCSV((String)this.config.npcsToShow());
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        this.npcRatios.remove(event.getNpc());
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        MenuAction menuAction;
        int type = event.getType();
        if (type >= 2000) {
            type -= 2000;
        }
        if (NPC_MENU_ACTIONS.contains(menuAction = MenuAction.of((int)type))) {
            NPC npc = this.client.getCachedNPCs()[event.getIdentifier()];
            if (this.config.showOnAllNpcs() || this.shouldShowNpc(npc)) {
                String baseText;
                String target = event.getTarget();
                String cleanTarget = Text.removeTags((String)event.getTarget());
                int levelStartIndex = cleanTarget.lastIndexOf(40);
                String levelText = levelStartIndex != -1 ? cleanTarget.substring(levelStartIndex) : "";
                switch (this.config.displayMode()) {
                    case LEVEL: {
                        baseText = levelText;
                        break;
                    }
                    case NAME: {
                        int endIndex = cleanTarget.lastIndexOf(40);
                        baseText = endIndex != -1 ? cleanTarget.substring(0, endIndex) : cleanTarget;
                        break;
                    }
                    default: {
                        baseText = cleanTarget;
                    }
                }
                double ratio = -1.0;
                if (npc.getHealthRatio() == -1) {
                    if (this.npcRatios.containsKey(npc)) {
                        ratio = this.npcRatios.get(npc);
                    }
                } else if (npc.getHealthRatio() >= 0) {
                    ratio = (double)npc.getHealthRatio() / (double)npc.getHealthScale();
                } else if (npc.isDead()) {
                    ratio = 0.0;
                }
                if (ratio != -1.0 || this.config.recolorWhenUnknown()) {
                    int splitIndex = (int)Math.round((double)baseText.length() * Math.abs(ratio));
                    Color[] tagColors = this.getColorsFromTags(target);
                    boolean isHealthUnknown = ratio < 0.0;
                    String finalText = this.buildFinalTargetText(cleanTarget, tagColors, splitIndex, baseText, levelText, isHealthUnknown);
                    MenuEntry[] menuEntries = this.client.getMenuEntries();
                    MenuEntry menuEntry = menuEntries[menuEntries.length - 1];
                    menuEntry.setTarget(finalText);
                    this.client.setMenuEntries(menuEntries);
                    if (!isHealthUnknown) {
                        this.npcRatios.put(npc, ratio);
                    }
                }
            }
        }
    }

    private String buildFinalTargetText(String target, Color[] tagColors, int splitIndex, String baseText, String levelText, boolean isHealthUnknown) {
        int monsterEndIndex = target.lastIndexOf(40);
        String monsterText = monsterEndIndex != -1 ? target.substring(0, monsterEndIndex) : target;
        String monsterTextTagged = ColorUtil.wrapWithColorTag((String)monsterText, (Color)tagColors[0]);
        String levelTextTagged = ColorUtil.wrapWithColorTag((String)levelText, (Color)tagColors[tagColors.length - 1]);
        Color hpColor = isHealthUnknown ? this.config.unknownColor() : this.config.hpColor();
        String hpText = ColorUtil.wrapWithColorTag((String)baseText.substring(0, splitIndex), (Color)hpColor);
        String bgText = ColorUtil.wrapWithColorTag((String)baseText.substring(splitIndex), (Color)this.config.bgColor());
        return (baseText.contains(monsterText) ? "" : monsterTextTagged) + hpText + bgText + (baseText.contains(levelText) ? "" : levelTextTagged);
    }

    private Color[] getColorsFromTags(String text) {
        Object[] result = new Color[]{};
        Matcher matcher = COLOR_TAG_PATTERN.matcher(text);
        while (matcher.find()) {
            result = (Color[])ArrayUtils.add((Object[])result, (Object)Color.decode("#" + matcher.group(1)));
        }
        return result;
    }

    private boolean shouldShowNpc(NPC npc) {
        String npcName = npc.getName();
        if (npcName != null) {
            return this.npcNames.stream().anyMatch(name -> WildcardMatcher.matches((String)name, (String)npcName));
        }
        return false;
    }
}

