/*
 * Decompiled with CFR 0.152.
 */
package com.slashswapper;

import com.google.inject.Provides;
import com.slashswapper.SlashSwapperConfig;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Slash Swapper")
public class SlashSwapperPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SlashSwapperPlugin.class);
    @Inject
    private Client client;
    @Inject
    private SlashSwapperConfig config;
    private boolean swapGuestChat = false;

    @Provides
    SlashSwapperConfig provideConfig(ConfigManager configManager) {
        return (SlashSwapperConfig)configManager.getConfig(SlashSwapperConfig.class);
    }

    public void startUp() {
        this.swapGuestChat = this.config.slashGuestChat();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("slashswapper")) {
            this.swapGuestChat = this.config.slashGuestChat();
        }
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent scriptCallbackEvent) {
        int intStackCount;
        if (!"chatDefaultReturn".equals(scriptCallbackEvent.getEventName())) {
            return;
        }
        int[] intStack = this.client.getIntStack();
        if (intStack[(intStackCount = this.client.getIntStackSize()) - 1] == 1 && intStack[intStackCount - 2] == 9) {
            intStack[intStackCount - 2] = !this.swapGuestChat ? 41 : 44;
        } else if (intStack[intStackCount - 1] == 2 && intStack[intStackCount - 2] == 41) {
            intStack[intStackCount - 2] = 9;
        } else if (intStack[intStackCount - 1] == 3 && intStack[intStackCount - 2] == 44) {
            intStack[intStackCount - 2] = !this.swapGuestChat ? 9 : 41;
        }
    }
}

