/*
 * Decompiled with CFR 0.152.
 */
package com.energyinfo;

import com.energyinfo.EnergyInfoConfig;
import com.energyinfo.EnergyInfoPlugin;
import java.awt.Color;
import java.awt.image.BufferedImage;
import net.runelite.api.Client;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxPriority;

class EnergyInfoBox
extends InfoBox {
    private static final Color STAMINA_ACTIVE = new Color(0, 255, 0, 255);
    private static final Color STAMINA_INACTIVE = new Color(255, 255, 255, 220);
    private static final Color BELOW_THRESHOLD = new Color(255, 0, 0, 220);
    private final EnergyInfoPlugin plugin;
    private final EnergyInfoConfig config;
    private final Client client;

    EnergyInfoBox(BufferedImage image, EnergyInfoPlugin plugin, Client client, EnergyInfoConfig config) {
        super(image, (Plugin)plugin);
        this.plugin = plugin;
        this.config = config;
        this.client = client;
        this.setTooltip("Run energy");
        this.setPriority(InfoBoxPriority.HIGH);
    }

    public Integer getRunEnergyPercentage() {
        return this.client.getEnergy() / 100;
    }

    public String getText() {
        return String.valueOf(this.getRunEnergyPercentage()) + "%";
    }

    public Color getTextColor() {
        if (this.client.getVarbitValue(25) != 0) {
            return STAMINA_ACTIVE;
        }
        if (this.config.lowEnergyThreshold() > 0 & this.getRunEnergyPercentage() < this.config.lowEnergyThreshold()) {
            return BELOW_THRESHOLD;
        }
        return STAMINA_INACTIVE;
    }

    public boolean render() {
        return this.config.displayInfobox();
    }
}

