/*
 * Decompiled with CFR 0.152.
 */
package com.erishiongames.unrankedkctracker;

import com.erishiongames.unrankedkctracker.UnrankedKcTrackerConfig;
import com.erishiongames.unrankedkctracker.UnrankedKcTrackerPanel;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Unranked KC Tracker")
public class UnrankedKcTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(UnrankedKcTrackerPlugin.class);
    public static final String CONFIG_GROUP = "unrankedkctracker";
    @Inject
    ClientToolbar clientToolbar;
    private UnrankedKcTrackerPanel panel;
    private NavigationButton navigationButton;
    @Inject
    private Client client;
    @Inject
    private UnrankedKcTrackerConfig config;
    @Inject
    private ScheduledExecutorService executor;

    protected void startUp() throws Exception {
        this.panel = (UnrankedKcTrackerPanel)((Object)this.injector.getInstance(UnrankedKcTrackerPanel.class));
        this.panel.init();
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"icon.png");
        this.navigationButton = NavigationButton.builder().tooltip("Unranked KC Tracker").icon(icon).priority(20).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navigationButton);
    }

    protected void shutDown() throws Exception {
        this.panel.deinit();
        this.clientToolbar.removeNavigation(this.navigationButton);
        this.panel = null;
        this.navigationButton = null;
    }

    @Provides
    UnrankedKcTrackerConfig provideConfig(ConfigManager configManager) {
        return (UnrankedKcTrackerConfig)configManager.getConfig(UnrankedKcTrackerConfig.class);
    }
}

