/*
 * Decompiled with CFR 0.152.
 */
package com.erishiongames.unrankedkctracker;

import com.erishiongames.unrankedkctracker.Bosses;
import com.erishiongames.unrankedkctracker.UnrankedKcTrackerPlugin;
import com.google.inject.Inject;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;

public class UnrankedKcTrackerPanel
extends PluginPanel {
    private JPanel bossPanel;
    @Inject
    private UnrankedKcTrackerPlugin unrankedKcTrackerPlugin;
    @Inject
    private EventBus eventBus;
    @Inject
    ConfigManager configManager;
    final Font smallFont = FontManager.getRunescapeSmallFont();

    void init() {
        this.setLayout(new FlowLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        this.bossPanel = new JPanel();
        this.bossPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        this.bossPanel.setLayout(new GridLayout(0, 1, 0, 0));
        Button refreshKCButton = new Button("Refresh KC");
        refreshKCButton.setFont(this.smallFont);
        refreshKCButton.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        refreshKCButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnrankedKcTrackerPanel.this.setUpBossKCPanels();
            }
        });
        panel.add(refreshKCButton);
        this.setUpBossKCPanels();
        this.add(panel, "Center");
        this.add(this.bossPanel, "Center");
        this.eventBus.register((Object)this);
    }

    void deinit() {
        this.eventBus.unregister((Object)this);
    }

    public void setUpBossKCPanels() {
        this.bossPanel.removeAll();
        for (Bosses boss : Bosses.values()) {
            int kc = this.getKcFromConfig(boss.getName());
            JLabel tempLabel = new JLabel();
            if (kc >= boss.getMinumiumKC()) {
                tempLabel.setForeground(ColorScheme.PROGRESS_INPROGRESS_COLOR);
                tempLabel.setToolTipText("KC is greater than or equal to the amount needed to be tracked on high scores, use that value instead");
            } else {
                tempLabel.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
                tempLabel.setToolTipText("KC is less than the amount needed to be tracked on high scores. Use this value");
            }
            tempLabel.setText(kc + ": " + boss.getName());
            tempLabel.setFont(this.smallFont);
            this.bossPanel.add(tempLabel);
        }
    }

    public int getKcFromConfig(String boss) {
        if (this.configManager == null) {
            return 0;
        }
        Integer killCount = (Integer)this.configManager.getRSProfileConfiguration("killcount", boss.toLowerCase(), Integer.TYPE);
        return killCount == null ? 0 : killCount;
    }
}

