/*
 * Decompiled with CFR 0.152.
 */
package ryanxie0.runelite.plugin.lingeringclicktooltips.wrapper;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.time.Duration;
import java.time.Instant;
import net.runelite.api.Client;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsConfig;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsLocation;
import ryanxie0.runelite.plugin.lingeringclicktooltips.renderable.alpha.AlphaTooltipComponent;
import ryanxie0.runelite.plugin.lingeringclicktooltips.wrapper.LingeringClickTooltipsWrapper;

public class LingeringClickTooltipsWrapperUtil {
    public static LingeringClickTooltipsWrapper buildTooltipWrapper(String tooltipText, Point location, Color backgroundColor, boolean isInfoTooltip, LingeringClickTooltipsConfig config) {
        LingeringClickTooltipsWrapper tooltipWrapper = new LingeringClickTooltipsWrapper();
        tooltipWrapper.setFaded(false);
        tooltipWrapper.setInfoTooltip(isInfoTooltip);
        tooltipWrapper.setClamped(false);
        tooltipWrapper.setText(tooltipText);
        tooltipWrapper.setBackgroundColor(backgroundColor);
        tooltipWrapper.setTimeOfCreation(Instant.now());
        tooltipWrapper.setLocation(location);
        tooltipWrapper.setTooltipDuration(LingeringClickTooltipsWrapperUtil.calculateTotalTooltipDuration(isInfoTooltip, config));
        return tooltipWrapper;
    }

    public static String getRawTooltipText(String option, String target) {
        Object tooltipText = option + (String)(target.equals("") || option.equals(target) ? "" : " " + target);
        tooltipText = ((String)tooltipText).replaceAll("\\s+$", "");
        return tooltipText;
    }

    public static Point getOffsetLocation(Point location, LingeringClickTooltipsConfig config) {
        if (config.tooltipLocation() == LingeringClickTooltipsLocation.ANCHORED || config.trackerMode() || config.tooltipLocation() == LingeringClickTooltipsLocation.FIXED) {
            return null;
        }
        location.translate(config.tooltipXOffset(), config.tooltipYOffset());
        return location;
    }

    public static Duration calculateTotalTooltipDuration(boolean isInfoTooltip, LingeringClickTooltipsConfig config) {
        int totalTooltipDuration = config.tooltipDuration();
        if (isInfoTooltip) {
            totalTooltipDuration = (int)((double)totalTooltipDuration * 1.5);
        } else if (config.fastMode()) {
            totalTooltipDuration = (int)((double)totalTooltipDuration / 2.0);
        }
        if (config.tooltipFadeIn() > 0) {
            totalTooltipDuration = (int)((double)totalTooltipDuration + (double)(totalTooltipDuration * config.tooltipFadeIn()) / 100.0);
        }
        if (config.tooltipFadeout() > 0) {
            totalTooltipDuration = (int)((double)totalTooltipDuration + (double)(totalTooltipDuration * config.tooltipFadeout()) / 100.0);
        }
        return Duration.ofMillis(totalTooltipDuration);
    }

    public static Point getClampedLocation(Dimension dimension, Point location, Client client, LingeringClickTooltipsConfig config) {
        int clampedX = location.x;
        int clampedY = location.y;
        int xPadding = config.clampXPadding();
        int yPadding = config.clampYPadding();
        int xMax = client.getCanvasWidth();
        int yMax = client.getCanvasHeight();
        if (clampedX < xPadding) {
            clampedX = xPadding;
        } else if (clampedX + dimension.width + xPadding > xMax) {
            clampedX = xMax - dimension.width - xPadding;
        }
        if (clampedY < yPadding) {
            clampedY = yPadding;
        } else if (clampedY + dimension.height + yPadding > yMax) {
            clampedY = yMax - dimension.height - yPadding;
        }
        return new Point(clampedX, clampedY);
    }

    public static void buildAlphaTooltipComponent(LingeringClickTooltipsWrapper tooltip, Client client) {
        AlphaTooltipComponent alphaTooltipComponent = new AlphaTooltipComponent();
        alphaTooltipComponent.setText(tooltip.getText());
        alphaTooltipComponent.setModIcons(client.getModIcons());
        alphaTooltipComponent.setBackgroundColor(tooltip.getBackgroundColor());
        if (tooltip.getLocation() != null) {
            alphaTooltipComponent.setPosition(tooltip.getLocation());
        }
        tooltip.setRenderableComponent(alphaTooltipComponent);
    }
}

