/*
 * Decompiled with CFR 0.152.
 */
package ryanxie0.runelite.plugin.lingeringclicktooltips.filtering;

import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsConfig;

public class LingeringClickTooltipsTrivialClicksManager {
    @Inject
    private LingeringClickTooltipsConfig config;
    private static Set<String> configurableTrivialClicks;
    private static Set<String> defaultTrivialClicks;
    private static Set<String> panelTrivialClicks;

    public void updateFromConfig(String configKey) {
        switch (configKey) {
            case "hideWalkHere": {
                LingeringClickTooltipsTrivialClicksManager.modifyConfigurableTrivialClicks(this.config.hideWalkHere(), "Walk here");
                break;
            }
            case "hideWalkHereWithTarget": {
                LingeringClickTooltipsTrivialClicksManager.modifyConfigurableTrivialClicks(this.config.hideWalkHereWithTarget(), "Walk here[TARGET]");
                break;
            }
            case "hideWield": {
                LingeringClickTooltipsTrivialClicksManager.modifyConfigurableTrivialClicks(this.config.hideWield(), "Wield");
                break;
            }
            case "hideWear": {
                LingeringClickTooltipsTrivialClicksManager.modifyConfigurableTrivialClicks(this.config.hideWear(), "Wear");
                break;
            }
            case "hideToggleRun": {
                LingeringClickTooltipsTrivialClicksManager.modifyConfigurableTrivialClicks(this.config.hideToggleRun(), "Toggle Run");
                break;
            }
            case "hideSpecialAttack": {
                LingeringClickTooltipsTrivialClicksManager.modifyConfigurableTrivialClicks(this.config.hideSpecialAttack(), "Use Special Attack");
                break;
            }
            case "hideQuickPrayers": {
                LingeringClickTooltipsTrivialClicksManager.modifyConfigurableTrivialClicks(this.config.hideQuickPrayers(), "Activate Quick-prayers");
                LingeringClickTooltipsTrivialClicksManager.modifyConfigurableTrivialClicks(this.config.hideQuickPrayers(), "Deactivate Quick-prayers");
                break;
            }
            case "hidePanelPrayers": {
                LingeringClickTooltipsTrivialClicksManager.modifyConfigurableTrivialClicks(this.config.hidePanelPrayers(), "ActivateDeactivate[PRAYER]");
                break;
            }
            case "hidePanelsGroup": {
                LingeringClickTooltipsTrivialClicksManager.modifyConfigurableTrivialClicks(this.config.hidePanelsGroup(), panelTrivialClicks);
                break;
            }
        }
    }

    private static void modifyConfigurableTrivialClicks(boolean configEnabled, String text) {
        if (configEnabled) {
            configurableTrivialClicks.add(text);
        } else {
            configurableTrivialClicks.remove(text);
        }
    }

    private static void modifyConfigurableTrivialClicks(boolean configEnabled, Set<String> textGroup) {
        if (configEnabled) {
            configurableTrivialClicks.addAll(textGroup);
        } else {
            configurableTrivialClicks.removeAll(textGroup);
        }
    }

    public static boolean defaultContains(String text) {
        return defaultTrivialClicks.contains(text);
    }

    public static boolean configurableContains(String text) {
        return configurableTrivialClicks.contains(text);
    }

    public void initialize() {
        this.initializeDefault();
        this.initializePanelGroup();
        this.initializeConfigurable();
    }

    public void destroy() {
        defaultTrivialClicks.clear();
        defaultTrivialClicks = null;
        panelTrivialClicks.clear();
        panelTrivialClicks = null;
        configurableTrivialClicks.clear();
        configurableTrivialClicks = null;
    }

    private void initializeDefault() {
        defaultTrivialClicks = new HashSet<String>();
        defaultTrivialClicks.add("Cancel");
        defaultTrivialClicks.add("Continue");
        defaultTrivialClicks.add("Play");
        defaultTrivialClicks.add("Logout");
        defaultTrivialClicks.add("Close");
        defaultTrivialClicks.add("World Switcher");
        defaultTrivialClicks.add("Select");
        defaultTrivialClicks.add("Drop");
        defaultTrivialClicks.add("Use");
        defaultTrivialClicks.add("Eat");
        defaultTrivialClicks.add("Move Sliding piece");
    }

    private void initializePanelGroup() {
        panelTrivialClicks = new HashSet<String>();
        panelTrivialClicks.add("Combat Options");
        panelTrivialClicks.add("Skills");
        panelTrivialClicks.add("Character Summary");
        panelTrivialClicks.add("Quest List");
        panelTrivialClicks.add("Achievement Diaries");
        panelTrivialClicks.add("Kourend Favour");
        panelTrivialClicks.add("Inventory");
        panelTrivialClicks.add("Worn Equipment");
        panelTrivialClicks.add("Prayer");
        panelTrivialClicks.add("Magic");
        panelTrivialClicks.add("Chat-channel");
        panelTrivialClicks.add("Your Clan");
        panelTrivialClicks.add("View another clan");
        panelTrivialClicks.add("Grouping");
        panelTrivialClicks.add("Friends List");
        panelTrivialClicks.add("Ignore List");
        panelTrivialClicks.add("Account Management");
        panelTrivialClicks.add("Settings");
        panelTrivialClicks.add("Emotes");
        panelTrivialClicks.add("Music Player");
    }

    private void initializeConfigurable() {
        configurableTrivialClicks = new HashSet<String>();
        LingeringClickTooltipsTrivialClicksManager.modifyConfigurableTrivialClicks(this.config.hideWalkHere(), "Walk here");
        LingeringClickTooltipsTrivialClicksManager.modifyConfigurableTrivialClicks(this.config.hideWalkHereWithTarget(), "Walk here[TARGET]");
        LingeringClickTooltipsTrivialClicksManager.modifyConfigurableTrivialClicks(this.config.hideWield(), "Wield");
        LingeringClickTooltipsTrivialClicksManager.modifyConfigurableTrivialClicks(this.config.hideWear(), "Wear");
        LingeringClickTooltipsTrivialClicksManager.modifyConfigurableTrivialClicks(this.config.hideToggleRun(), "Toggle Run");
        LingeringClickTooltipsTrivialClicksManager.modifyConfigurableTrivialClicks(this.config.hideSpecialAttack(), "Use Special Attack");
        LingeringClickTooltipsTrivialClicksManager.modifyConfigurableTrivialClicks(this.config.hideQuickPrayers(), "Activate Quick-prayers");
        LingeringClickTooltipsTrivialClicksManager.modifyConfigurableTrivialClicks(this.config.hideQuickPrayers(), "Deactivate Quick-prayers");
        LingeringClickTooltipsTrivialClicksManager.modifyConfigurableTrivialClicks(this.config.hidePanelPrayers(), "ActivateDeactivate[PRAYER]");
        LingeringClickTooltipsTrivialClicksManager.modifyConfigurableTrivialClicks(this.config.hidePanelsGroup(), panelTrivialClicks);
    }
}

