/*
 * Decompiled with CFR 0.152.
 */
package ryanxie0.runelite.plugin.lingeringclicktooltips.filtering;

import java.util.LinkedList;
import java.util.List;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsConfig;
import ryanxie0.runelite.plugin.lingeringclicktooltips.filtering.LingeringClickTooltipsFilterMode;
import ryanxie0.runelite.plugin.lingeringclicktooltips.filtering.LingeringClickTooltipsFilteringUtil;
import ryanxie0.runelite.plugin.lingeringclicktooltips.filtering.LingeringClickTooltipsTrivialClicksManager;

public class LingeringClickTooltipsFiltering {
    public static boolean shouldRenderTooltip(String tooltipText, boolean isHide, boolean isCtrlPressed, LingeringClickTooltipsConfig config) {
        String filterableText = LingeringClickTooltipsFilteringUtil.removeTags(tooltipText);
        boolean isHideMode = LingeringClickTooltipsFiltering.isHideMode(isHide, isCtrlPressed, config.ctrlTogglesHide());
        boolean isTrivialClick = LingeringClickTooltipsFiltering.isTrivialClick(filterableText, config);
        boolean isFilteredByList = LingeringClickTooltipsFiltering.isFilteredByList(filterableText, config);
        boolean isBlockedClickTooltip = LingeringClickTooltipsFiltering.isBlockedClickTooltip(filterableText);
        boolean isHiddenBlockedClickTooltip = isBlockedClickTooltip && !config.showBlockedClicks();
        return !isHideMode && !isTrivialClick && (!isFilteredByList || isBlockedClickTooltip) && !isHiddenBlockedClickTooltip;
    }

    public static boolean isHideMode(boolean isHide, boolean isCtrlPressed, boolean ctrlTogglesHide) {
        return isHide && (!isCtrlPressed || !ctrlTogglesHide);
    }

    public static boolean isTrivialClick(String tooltipText, LingeringClickTooltipsConfig config) {
        if (LingeringClickTooltipsTrivialClicksManager.defaultContains(tooltipText)) {
            return true;
        }
        if (config.hideTrivialClicks() && !config.trackerMode()) {
            if (tooltipText.contains("Walk here") && tooltipText.length() > "Walk here".length()) {
                return LingeringClickTooltipsTrivialClicksManager.configurableContains("Walk here[TARGET]");
            }
            if ((tooltipText.contains("Activate") || tooltipText.contains("Deactivate")) && !tooltipText.contains("Quick-prayers")) {
                return LingeringClickTooltipsTrivialClicksManager.configurableContains("ActivateDeactivate[PRAYER]");
            }
            return LingeringClickTooltipsTrivialClicksManager.configurableContains(tooltipText);
        }
        return false;
    }

    public static boolean isFilteredByList(String tooltipText, LingeringClickTooltipsConfig config) {
        if (config.filterMode() == LingeringClickTooltipsFilterMode.BLACKLIST) {
            List<String> blacklist = LingeringClickTooltipsFilteringUtil.csvToList(config.blacklist());
            return blacklist.contains(tooltipText);
        }
        if (config.filterMode() == LingeringClickTooltipsFilterMode.WHITELIST) {
            List<String> whitelist = LingeringClickTooltipsFilteringUtil.csvToList(config.whitelist());
            return !whitelist.contains(tooltipText);
        }
        return false;
    }

    public static boolean isBlockedClickTooltip(String tooltipText) {
        return !(!tooltipText.contains("Bypass") && !tooltipText.contains("Blocked by") || !tooltipText.contains(LingeringClickTooltipsFilterMode.BLACKLIST.toString()) && !tooltipText.contains(LingeringClickTooltipsFilterMode.WHITELIST.toString()) && !tooltipText.contains("SHIFT"));
    }

    public static String updateFilterLists(LingeringClickTooltipsConfig config, String tooltipText, boolean isPeek) {
        Object infoTooltipText = "";
        if (tooltipText == null || tooltipText.isEmpty()) {
            return infoTooltipText;
        }
        LingeringClickTooltipsFilterMode filterMode = config.filterMode();
        String filterableText = LingeringClickTooltipsFilteringUtil.removeTags(tooltipText);
        if (filterMode == LingeringClickTooltipsFilterMode.BLACKLIST) {
            LinkedList<String> blacklist = new LinkedList<String>(LingeringClickTooltipsFilteringUtil.csvToList(config.blacklist()));
            if (blacklist.contains(filterableText)) {
                blacklist.remove(filterableText);
                infoTooltipText = (String)infoTooltipText + LingeringClickTooltipsFilterMode.BLACKLIST + "REMOVE" + tooltipText;
            } else {
                blacklist.add(filterableText);
                infoTooltipText = (String)infoTooltipText + LingeringClickTooltipsFilterMode.BLACKLIST + "ADD" + tooltipText;
            }
            if (!isPeek) {
                config.setBlacklist(LingeringClickTooltipsFilteringUtil.listToCsv(blacklist));
            }
        } else if (filterMode == LingeringClickTooltipsFilterMode.WHITELIST) {
            LinkedList<String> whitelist = new LinkedList<String>(LingeringClickTooltipsFilteringUtil.csvToList(config.whitelist()));
            if (whitelist.contains(filterableText)) {
                whitelist.remove(filterableText);
                infoTooltipText = (String)infoTooltipText + LingeringClickTooltipsFilterMode.WHITELIST + "REMOVE" + tooltipText;
            } else {
                whitelist.add(filterableText);
                infoTooltipText = (String)infoTooltipText + LingeringClickTooltipsFilterMode.WHITELIST + "ADD" + tooltipText;
            }
            if (!isPeek) {
                config.setWhitelist(LingeringClickTooltipsFilteringUtil.listToCsv(whitelist));
            }
        } else if (filterMode == LingeringClickTooltipsFilterMode.NONE) {
            infoTooltipText = (String)infoTooltipText + "No filter mode enabled";
        }
        return infoTooltipText;
    }
}

