/*
 * Decompiled with CFR 0.152.
 */
package ryanxie0.runelite.plugin.lingeringclicktooltips.fade;

import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsConfig;

public class LingeringClickTooltipsFadeUtil {
    public static double getMaximumOpacity(LingeringClickTooltipsConfig config) {
        if (config.lightMode()) {
            return (double)config.maximumOpacity() / 100.0 * 0.75;
        }
        return (double)config.maximumOpacity() / 100.0;
    }

    public static int calculateFadeInPeriodThreshold(LingeringClickTooltipsConfig config, boolean isInfoTooltip) {
        if (isInfoTooltip) {
            return (int)((double)(config.tooltipDuration() * config.tooltipFadeIn()) / 100.0 / 1.5);
        }
        if (config.fastMode()) {
            return (int)((double)(config.tooltipDuration() * config.tooltipFadeIn()) / 100.0 / 2.0);
        }
        return (int)((double)(config.tooltipDuration() * config.tooltipFadeIn()) / 100.0);
    }

    public static int calculateFadeoutPeriodThreshold(LingeringClickTooltipsConfig config, boolean isInfoTooltip) {
        int fadeoutPeriodThreshold = config.tooltipDuration();
        if (isInfoTooltip) {
            return (int)((double)fadeoutPeriodThreshold * 1.5);
        }
        if (config.fastMode()) {
            return (int)((double)fadeoutPeriodThreshold / 2.0);
        }
        return LingeringClickTooltipsFadeUtil.calculateFadeInPeriodThreshold(config, isInfoTooltip) + fadeoutPeriodThreshold;
    }

    public static double applyFadeIn(double alphaModifier, long sinceCreation, long fadeInPeriodThreshold) {
        return alphaModifier * (double)sinceCreation / (double)fadeInPeriodThreshold;
    }

    public static double applyFadeout(double alphaModifier, long timeRemaining, long fadeoutPeriod) {
        return alphaModifier * (double)timeRemaining / (double)fadeoutPeriod;
    }

    public static boolean isInFadeInPeriod(long sinceCreation, long fadeInPeriodThreshold) {
        return sinceCreation < fadeInPeriodThreshold;
    }

    public static boolean isInFadeoutPeriod(long sinceCreation, long fadeoutPeriodThreshold) {
        return sinceCreation > fadeoutPeriodThreshold;
    }
}

