/*
 * Decompiled with CFR 0.152.
 */
package ryanxie0.runelite.plugin.lingeringclicktooltips.fade;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsConfig;
import ryanxie0.runelite.plugin.lingeringclicktooltips.fade.LingeringClickTooltipsFadeUtil;
import ryanxie0.runelite.plugin.lingeringclicktooltips.wrapper.LingeringClickTooltipsWrapper;

public class LingeringClickTooltipsFade {
    public static double calculateAlphaModifier(LingeringClickTooltipsWrapper tooltip, LingeringClickTooltipsConfig config) {
        double alphaModifier = LingeringClickTooltipsFadeUtil.getMaximumOpacity(config);
        Duration sinceCreation = Duration.between(tooltip.getTimeOfCreation(), Instant.now());
        int fadeInPeriodThreshold = LingeringClickTooltipsFadeUtil.calculateFadeInPeriodThreshold(config, tooltip.isInfoTooltip());
        int fadeOutPeriodThreshold = LingeringClickTooltipsFadeUtil.calculateFadeoutPeriodThreshold(config, tooltip.isInfoTooltip());
        if (LingeringClickTooltipsFadeUtil.isInFadeInPeriod(sinceCreation.toMillis(), fadeInPeriodThreshold)) {
            alphaModifier = LingeringClickTooltipsFadeUtil.applyFadeIn(alphaModifier, sinceCreation.toMillis(), fadeInPeriodThreshold);
        } else if (LingeringClickTooltipsFadeUtil.isInFadeoutPeriod(sinceCreation.toMillis(), fadeOutPeriodThreshold)) {
            Duration totalTooltipDuration = tooltip.getTooltipDuration();
            long timeRemaining = totalTooltipDuration.minus(sinceCreation).toMillis();
            long fadeoutPeriod = totalTooltipDuration.toMillis() - (long)fadeOutPeriodThreshold;
            alphaModifier = LingeringClickTooltipsFadeUtil.applyFadeout(alphaModifier, timeRemaining, fadeoutPeriod);
        }
        return alphaModifier;
    }

    public static void refreshInfoTooltip(LingeringClickTooltipsWrapper infoTooltip, LingeringClickTooltipsConfig config) {
        if (infoTooltip.isFaded()) {
            infoTooltip.setFaded(false);
            infoTooltip.setTimeOfCreation(Instant.now());
            return;
        }
        Duration sinceCreation = Duration.between(infoTooltip.getTimeOfCreation(), Instant.now());
        int fadeInPeriodThreshold = LingeringClickTooltipsFadeUtil.calculateFadeInPeriodThreshold(config, infoTooltip.isInfoTooltip());
        if (!LingeringClickTooltipsFadeUtil.isInFadeInPeriod(sinceCreation.toMillis(), fadeInPeriodThreshold)) {
            infoTooltip.setTimeOfCreation(Instant.now().minus(fadeInPeriodThreshold, ChronoUnit.MILLIS));
        }
    }

    public static void refreshTooltipTimeOfCreation(LingeringClickTooltipsWrapper tooltip) {
        tooltip.setTimeOfCreation(Instant.now());
    }
}

