/*
 * Decompiled with CFR 0.152.
 */
package ryanxie0.runelite.plugin.lingeringclicktooltips.color;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.client.config.RuneLiteConfig;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsConfig;
import ryanxie0.runelite.plugin.lingeringclicktooltips.color.LingeringClickTooltipsColorConstants;

public class LingeringClickTooltipsTextColorManager {
    @Inject
    private RuneLiteConfig runeLiteConfig;
    @Inject
    private LingeringClickTooltipsConfig config;
    private static Map<String, Color> textToColorMap;

    public void updateFromConfig(String configKey) {
        switch (configKey) {
            case "useCustomBackgroundColor": 
            case "customBackgroundColor": {
                LingeringClickTooltipsTextColorManager.modifyTextToColorMap(this.config.useCustomBackgroundColor(), "customBackgroundColor", this.config.customBackgroundColor());
                break;
            }
            case "useCustomTextColor": 
            case "customTextColor": {
                LingeringClickTooltipsTextColorManager.modifyTextToColorMap(this.config.useCustomTextColor(), "customTextColor", this.config.customTextColor());
                break;
            }
            case "overlayBackgroundColor": {
                LingeringClickTooltipsTextColorManager.modifyTextToColorMap(true, "overlayBackgroundColor", this.runeLiteConfig.overlayBackgroundColor());
                break;
            }
        }
    }

    private static void modifyTextToColorMap(boolean configEnabled, String text, Color color) {
        if (configEnabled) {
            textToColorMap.put(text, color);
        } else {
            textToColorMap.remove(text);
        }
    }

    public static Color getColor(String text) {
        return textToColorMap.get(text);
    }

    public void initialize() {
        this.initializeTextToColorMap();
    }

    public void destroy() {
        textToColorMap.clear();
        textToColorMap = null;
    }

    private void initializeTextToColorMap() {
        textToColorMap = new HashMap<String, Color>();
        textToColorMap.put("Tooltips SHOWN", LingeringClickTooltipsColorConstants.TRANSPARENT);
        textToColorMap.put("Tooltips HIDDEN", LingeringClickTooltipsColorConstants.TRANSPARENT);
        textToColorMap.put("SHOWN", LingeringClickTooltipsColorConstants.LIGHT_GREEN);
        textToColorMap.put("HIDDEN", LingeringClickTooltipsColorConstants.LIGHT_RED);
        textToColorMap.put(LingeringClickTooltipsColorConstants.BLACKLIST_BACKGROUND_COLOR, LingeringClickTooltipsColorConstants.DARKER_GRAY);
        textToColorMap.put(LingeringClickTooltipsColorConstants.WHITELIST_BACKGROUND_COLOR, LingeringClickTooltipsColorConstants.MEDIUM_GRAY);
        textToColorMap.put(LingeringClickTooltipsColorConstants.BLACKLIST_TEXT_COLOR, Color.YELLOW);
        textToColorMap.put(LingeringClickTooltipsColorConstants.WHITELIST_TEXT_COLOR, Color.ORANGE);
        textToColorMap.put("ADD", LingeringClickTooltipsColorConstants.LIGHT_GREEN);
        textToColorMap.put("REMOVE", LingeringClickTooltipsColorConstants.LIGHT_RED);
        textToColorMap.put("No filter mode enabled.backgroundColor", LingeringClickTooltipsColorConstants.TRANSPARENT);
        textToColorMap.put("No filter mode enabled.textColor", LingeringClickTooltipsColorConstants.LIGHT_RED);
        textToColorMap.put("Last click.backgroundColor", LingeringClickTooltipsColorConstants.TRANSPARENT);
        textToColorMap.put("Last click.textColor", LingeringClickTooltipsColorConstants.LIGHTER_GRAY);
        textToColorMap.put("Blocked by", LingeringClickTooltipsColorConstants.LIGHT_RED);
        textToColorMap.put("Bypass", LingeringClickTooltipsColorConstants.LIGHT_GREEN);
        textToColorMap.put("SHIFT", LingeringClickTooltipsColorConstants.LIGHTER_GRAY);
        textToColorMap.put("Blocked bySHIFT.backgroundColor", LingeringClickTooltipsColorConstants.TRANSPARENT);
        LingeringClickTooltipsTextColorManager.modifyTextToColorMap(this.config.useCustomBackgroundColor(), "customBackgroundColor", this.config.customBackgroundColor());
        LingeringClickTooltipsTextColorManager.modifyTextToColorMap(this.config.useCustomTextColor(), "customTextColor", this.config.customTextColor());
        LingeringClickTooltipsTextColorManager.modifyTextToColorMap(true, "overlayBackgroundColor", this.runeLiteConfig.overlayBackgroundColor());
    }
}

