/*
 * Decompiled with CFR 0.152.
 */
package ryanxie0.runelite.plugin.lingeringclicktooltips.color;

import java.awt.Color;
import ryanxie0.runelite.plugin.lingeringclicktooltips.color.LingeringClickTooltipsColorConstants;
import ryanxie0.runelite.plugin.lingeringclicktooltips.color.LingeringClickTooltipsColorUtil;
import ryanxie0.runelite.plugin.lingeringclicktooltips.color.LingeringClickTooltipsTextColorManager;
import ryanxie0.runelite.plugin.lingeringclicktooltips.filtering.LingeringClickTooltipsFilterMode;
import ryanxie0.runelite.plugin.lingeringclicktooltips.filtering.LingeringClickTooltipsFilteringUtil;

public class LingeringClickTooltipsColor {
    public static String applyCustomTextColor(String tooltipText, boolean overrideMenuColors) {
        String tooltipTextColor = LingeringClickTooltipsColorUtil.getColorTag(Color.WHITE);
        Color customTextColor = LingeringClickTooltipsTextColorManager.getColor("customTextColor");
        if (customTextColor != null) {
            tooltipTextColor = LingeringClickTooltipsColorUtil.getColorTag(customTextColor);
            if (overrideMenuColors) {
                tooltipText = LingeringClickTooltipsFilteringUtil.removeTags(tooltipText);
            }
        }
        return tooltipTextColor + tooltipText;
    }

    public static String getBlockedClickTextWithColor(String blockedClickText) {
        Object blockedClickTextWithColor = "";
        if (blockedClickText.contains("Bypass")) {
            blockedClickText = blockedClickText.substring("Bypass".length());
            blockedClickTextWithColor = (String)blockedClickTextWithColor + LingeringClickTooltipsColorUtil.getColorTag("Bypass") + "Bypass ";
        } else if (blockedClickText.contains("Blocked by")) {
            blockedClickText = blockedClickText.substring("Blocked by".length());
            blockedClickTextWithColor = (String)blockedClickTextWithColor + LingeringClickTooltipsColorUtil.getColorTag("Blocked by") + "Blocked by ";
        }
        if (blockedClickText.contains(LingeringClickTooltipsFilterMode.BLACKLIST.toString())) {
            blockedClickTextWithColor = (String)blockedClickTextWithColor + LingeringClickTooltipsColorUtil.getColorTag(LingeringClickTooltipsColorConstants.BLACKLIST_TEXT_COLOR) + LingeringClickTooltipsFilterMode.BLACKLIST;
        } else if (blockedClickText.contains(LingeringClickTooltipsFilterMode.WHITELIST.toString())) {
            blockedClickTextWithColor = (String)blockedClickTextWithColor + LingeringClickTooltipsColorUtil.getColorTag(LingeringClickTooltipsColorConstants.WHITELIST_TEXT_COLOR) + LingeringClickTooltipsFilterMode.WHITELIST;
        } else if (blockedClickText.contains("SHIFT")) {
            blockedClickTextWithColor = (String)blockedClickTextWithColor + LingeringClickTooltipsColorUtil.getColorTag("SHIFT") + "SHIFT";
        }
        if (!blockedClickText.isEmpty()) {
            blockedClickTextWithColor = (String)blockedClickTextWithColor + LingeringClickTooltipsColorUtil.getColorTag(Color.WHITE) + ": ";
        }
        return blockedClickTextWithColor;
    }

    public static String applyInfoTooltipTextColor(String infoTooltipText, boolean isPeek) {
        String hideModeTooltipWithTextColor = LingeringClickTooltipsColor.getHideModeTooltipTextWithColor(infoTooltipText);
        if (!hideModeTooltipWithTextColor.isEmpty()) {
            return hideModeTooltipWithTextColor;
        }
        String filterListActionTooltipTextWithColor = LingeringClickTooltipsColor.getFilterListActionTooltipTextWithColor(infoTooltipText, isPeek);
        if (!filterListActionTooltipTextWithColor.isEmpty()) {
            return filterListActionTooltipTextWithColor;
        }
        String peekLastClickTooltipTextWithColor = LingeringClickTooltipsColor.getPeekLastClickTooltipTextWithColor(infoTooltipText);
        if (!peekLastClickTooltipTextWithColor.isEmpty()) {
            return peekLastClickTooltipTextWithColor;
        }
        return infoTooltipText;
    }

    private static String getHideModeTooltipTextWithColor(String tooltipText) {
        Object hideModeTooltipTextWithColor = "";
        if (tooltipText.contains("Tooltips")) {
            if (tooltipText.contains("HIDDEN")) {
                hideModeTooltipTextWithColor = (String)hideModeTooltipTextWithColor + LingeringClickTooltipsColorUtil.getColorTag(Color.WHITE) + "Tooltips " + LingeringClickTooltipsColorUtil.getColorTag("HIDDEN") + "HIDDEN";
            } else if (tooltipText.contains("SHOWN")) {
                hideModeTooltipTextWithColor = (String)hideModeTooltipTextWithColor + LingeringClickTooltipsColorUtil.getColorTag(Color.WHITE) + "Tooltips " + LingeringClickTooltipsColorUtil.getColorTag("SHOWN") + "SHOWN";
            }
        }
        return hideModeTooltipTextWithColor;
    }

    private static String getFilterListActionTooltipTextWithColor(String tooltipText, boolean isPeek) {
        Object filterListTooltipTextColor = "";
        String filterListAction = LingeringClickTooltipsFilteringUtil.extractFilterListAction(tooltipText);
        if (filterListAction.contains(LingeringClickTooltipsFilterMode.BLACKLIST.toString())) {
            tooltipText = tooltipText.substring(LingeringClickTooltipsFilterMode.BLACKLIST.toString().length());
            filterListTooltipTextColor = (String)filterListTooltipTextColor + LingeringClickTooltipsColorUtil.getColorTag(LingeringClickTooltipsColorConstants.BLACKLIST_TEXT_COLOR) + LingeringClickTooltipsFilterMode.BLACKLIST + " ";
        } else if (filterListAction.contains(LingeringClickTooltipsFilterMode.WHITELIST.toString())) {
            tooltipText = tooltipText.substring(LingeringClickTooltipsFilterMode.WHITELIST.toString().length());
            filterListTooltipTextColor = (String)filterListTooltipTextColor + LingeringClickTooltipsColorUtil.getColorTag(LingeringClickTooltipsColorConstants.WHITELIST_TEXT_COLOR) + LingeringClickTooltipsFilterMode.WHITELIST + " ";
        } else if (filterListAction.contains("No filter mode enabled")) {
            filterListTooltipTextColor = (String)filterListTooltipTextColor + LingeringClickTooltipsColorUtil.getColorTag("No filter mode enabled.textColor");
        }
        if (filterListAction.contains("ADD")) {
            tooltipText = tooltipText.substring("ADD".length());
            filterListTooltipTextColor = (String)filterListTooltipTextColor + LingeringClickTooltipsColorUtil.getColorTag("ADD") + "ADD" + (isPeek ? "? " : "ED ");
        } else if (filterListAction.contains("REMOVE")) {
            tooltipText = tooltipText.substring("REMOVE".length());
            filterListTooltipTextColor = (String)filterListTooltipTextColor + LingeringClickTooltipsColorUtil.getColorTag("REMOVE") + "REMOVE" + (isPeek ? "? " : "D ");
        }
        return ((String)filterListTooltipTextColor).isEmpty() ? "" : (String)filterListTooltipTextColor + tooltipText;
    }

    private static String getPeekLastClickTooltipTextWithColor(String tooltipText) {
        Object peekLastClickTooltipTextColor = "";
        if (tooltipText.contains("Last click")) {
            tooltipText = tooltipText.substring("Last click".length());
            peekLastClickTooltipTextColor = LingeringClickTooltipsColorUtil.getColorTag("Last click.textColor") + "Last click: ";
        }
        return (String)peekLastClickTooltipTextColor + tooltipText;
    }

    public static Color getTooltipBackgroundColor(String tooltipText) {
        Color specialBackgroundColor = LingeringClickTooltipsColor.getSpecialBackgroundColor(tooltipText = LingeringClickTooltipsFilteringUtil.removeTags(tooltipText));
        if (specialBackgroundColor != null) {
            return specialBackgroundColor;
        }
        Color textMappedBackgroundColor = LingeringClickTooltipsTextColorManager.getColor(tooltipText);
        if (textMappedBackgroundColor != null) {
            return textMappedBackgroundColor;
        }
        Color customBackgroundColor = LingeringClickTooltipsTextColorManager.getColor("customBackgroundColor");
        if (customBackgroundColor != null) {
            return customBackgroundColor;
        }
        return LingeringClickTooltipsTextColorManager.getColor("overlayBackgroundColor");
    }

    private static Color getSpecialBackgroundColor(String tooltipText) {
        String filterListAction = LingeringClickTooltipsFilteringUtil.extractFilterListAction(tooltipText);
        if (filterListAction.contains(LingeringClickTooltipsFilterMode.BLACKLIST.toString())) {
            return LingeringClickTooltipsTextColorManager.getColor(LingeringClickTooltipsColorConstants.BLACKLIST_BACKGROUND_COLOR);
        }
        if (filterListAction.contains(LingeringClickTooltipsFilterMode.WHITELIST.toString())) {
            return LingeringClickTooltipsTextColorManager.getColor(LingeringClickTooltipsColorConstants.WHITELIST_BACKGROUND_COLOR);
        }
        if (filterListAction.contains("No filter mode enabled")) {
            return LingeringClickTooltipsTextColorManager.getColor("No filter mode enabled.backgroundColor");
        }
        if (tooltipText.contains("Last click")) {
            return LingeringClickTooltipsTextColorManager.getColor("Last click.backgroundColor");
        }
        if (tooltipText.contains("Blocked by") && tooltipText.contains("SHIFT")) {
            return LingeringClickTooltipsTextColorManager.getColor("Blocked bySHIFT.backgroundColor");
        }
        return null;
    }
}

