/*
 * Decompiled with CFR 0.152.
 */
package ryanxie0.runelite.plugin.lingeringclicktooltips;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.inject.Inject;
import net.runelite.api.events.MenuOptionClicked;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsConfig;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsInputListener;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsLocation;
import ryanxie0.runelite.plugin.lingeringclicktooltips.color.LingeringClickTooltipsColor;
import ryanxie0.runelite.plugin.lingeringclicktooltips.fade.LingeringClickTooltipsFade;
import ryanxie0.runelite.plugin.lingeringclicktooltips.filtering.LingeringClickTooltipsFilterMode;
import ryanxie0.runelite.plugin.lingeringclicktooltips.filtering.LingeringClickTooltipsFiltering;
import ryanxie0.runelite.plugin.lingeringclicktooltips.filtering.LingeringClickTooltipsFilteringUtil;
import ryanxie0.runelite.plugin.lingeringclicktooltips.wrapper.LingeringClickTooltipsWrapper;
import ryanxie0.runelite.plugin.lingeringclicktooltips.wrapper.LingeringClickTooltipsWrapperUtil;

public class LingeringClickTooltipsQueueManager {
    @Inject
    private LingeringClickTooltipsConfig config;
    private Queue<LingeringClickTooltipsWrapper> tooltips;
    private LingeringClickTooltipsWrapper fixedLocationTooltip;
    private LingeringClickTooltipsWrapper infoTooltip;
    private LingeringClickTooltipsWrapper tickSyncTooltip;
    private List<LingeringClickTooltipsWrapper> tooltipsToFlush;
    private LingeringClickTooltipsInputListener inputListener;
    private String lastUnfilteredTooltipText;
    private String lastTooltipText;
    private String lastInfoTooltipText;

    public void createNewTooltip(MenuOptionClicked event) {
        String rawTooltipText = LingeringClickTooltipsWrapperUtil.getRawTooltipText(event.getMenuOption(), event.getMenuTarget());
        Object tooltipText = LingeringClickTooltipsColor.applyCustomTextColor(rawTooltipText, this.config.overrideMenuColors());
        this.lastTooltipText = tooltipText;
        tooltipText = this.getBlockedClickText((String)tooltipText, event) + (String)tooltipText;
        this.setRenderedTooltip((String)tooltipText);
    }

    private String getBlockedClickText(String tooltipText, MenuOptionClicked event) {
        Object blockedClickText = "";
        if (this.config.filterMode() == LingeringClickTooltipsFilterMode.NONE) {
            return blockedClickText;
        }
        if (this.config.shiftBlocks() && this.inputListener.isShiftPressed()) {
            event.consume();
            blockedClickText = "Blocked bySHIFT";
        } else if (this.config.blockFilteredClicks() && LingeringClickTooltipsFiltering.isFilteredByList(LingeringClickTooltipsFilteringUtil.removeTags(tooltipText), this.config)) {
            if (this.config.ctrlBypassesBlock() && this.inputListener.isCtrlPressed()) {
                blockedClickText = "Bypass" + this.config.filterMode();
            } else {
                event.consume();
                blockedClickText = "Blocked by" + this.config.filterMode();
            }
        }
        return LingeringClickTooltipsColor.getBlockedClickTextWithColor((String)blockedClickText);
    }

    private void setRenderedTooltip(String tooltipText) {
        if (LingeringClickTooltipsFiltering.shouldRenderTooltip(tooltipText, this.inputListener.isHide(), this.inputListener.isCtrlPressed(), this.config)) {
            LingeringClickTooltipsWrapper tooltip = LingeringClickTooltipsWrapperUtil.buildTooltipWrapper(tooltipText, LingeringClickTooltipsWrapperUtil.getOffsetLocation(this.inputListener.getLastClickPoint(), this.config), LingeringClickTooltipsColor.getTooltipBackgroundColor(tooltipText), false, this.config);
            if (this.config.tickSyncMode()) {
                this.tickSyncTooltip = tooltip;
            } else if (this.config.tooltipLocation() == LingeringClickTooltipsLocation.FIXED) {
                this.fixedLocationTooltip = tooltip;
            } else {
                this.addTooltip(tooltip);
            }
            this.lastUnfilteredTooltipText = tooltipText;
        }
    }

    private void addTooltip(LingeringClickTooltipsWrapper tooltip) {
        this.tooltips.add(tooltip);
        if (this.tooltips.size() > this.config.maximumTooltipsShown()) {
            this.tooltipsToFlush.add(this.tooltips.peek());
        }
    }

    public void processTick() {
        if (this.config.tickSyncMode() && this.tickSyncTooltip != null) {
            LingeringClickTooltipsFade.refreshTooltipTimeOfCreation(this.tickSyncTooltip);
            if (this.config.tooltipLocation() == LingeringClickTooltipsLocation.FIXED) {
                this.fixedLocationTooltip = this.tickSyncTooltip;
            } else {
                this.addTooltip(this.tickSyncTooltip);
            }
            this.tickSyncTooltip = null;
        }
    }

    private void createNewInfoTooltip(String infoTooltipText) {
        if (this.lastInfoTooltipText != null && !this.lastInfoTooltipText.isEmpty() && LingeringClickTooltipsFilteringUtil.removeTags(infoTooltipText).equals(LingeringClickTooltipsFilteringUtil.removeTags(this.lastInfoTooltipText))) {
            LingeringClickTooltipsFade.refreshInfoTooltip(this.infoTooltip, this.config);
        } else {
            this.infoTooltip = LingeringClickTooltipsWrapperUtil.buildTooltipWrapper(infoTooltipText, null, LingeringClickTooltipsColor.getTooltipBackgroundColor(infoTooltipText), true, this.config);
            this.lastInfoTooltipText = infoTooltipText;
        }
    }

    public void createHideModeInfoTooltip(boolean isHide) {
        String hideModeTooltipText = isHide ? "TooltipsHIDDEN" : "TooltipsSHOWN";
        String toggledHideModeTooltipTextWithColor = LingeringClickTooltipsColor.applyInfoTooltipTextColor(hideModeTooltipText, false);
        this.createNewInfoTooltip(toggledHideModeTooltipTextWithColor);
    }

    public void createFilterListUpdateInfoTooltip() {
        String filterListUpdateTooltipText = LingeringClickTooltipsFiltering.updateFilterLists(this.config, this.lastTooltipText, false);
        if (!filterListUpdateTooltipText.isEmpty()) {
            String filterListUpdateTooltipTextWithColor = LingeringClickTooltipsColor.applyInfoTooltipTextColor(filterListUpdateTooltipText, false);
            this.createNewInfoTooltip(filterListUpdateTooltipTextWithColor);
        }
    }

    public void createPeekInfoTooltip() {
        String filterListUpdateTooltipText = LingeringClickTooltipsFiltering.updateFilterLists(this.config, this.lastTooltipText, true);
        if (!filterListUpdateTooltipText.isEmpty() && !filterListUpdateTooltipText.contains("No filter mode enabled")) {
            String filterListUpdateTooltipTextWithColor = LingeringClickTooltipsColor.applyInfoTooltipTextColor(filterListUpdateTooltipText, true);
            this.createNewInfoTooltip(filterListUpdateTooltipTextWithColor);
        } else if (this.lastUnfilteredTooltipText != null && !this.lastUnfilteredTooltipText.isEmpty()) {
            String peekLastClickTooltipTextWithColor = LingeringClickTooltipsColor.applyInfoTooltipTextColor("Last click" + this.lastUnfilteredTooltipText, true);
            this.createNewInfoTooltip(peekLastClickTooltipTextWithColor);
        }
    }

    public void addTooltipToFlush(LingeringClickTooltipsWrapper tooltip) {
        this.tooltipsToFlush.add(tooltip);
    }

    public void flushTooltips() {
        for (LingeringClickTooltipsWrapper tooltip : this.tooltipsToFlush) {
            this.tooltips.remove(tooltip);
        }
    }

    public void initialize(LingeringClickTooltipsInputListener inputListener) {
        this.inputListener = inputListener;
        this.tooltips = new LinkedList<LingeringClickTooltipsWrapper>();
        this.tooltipsToFlush = new LinkedList<LingeringClickTooltipsWrapper>();
    }

    public void destroy() {
        this.inputListener = null;
        this.tooltips.clear();
        this.tooltips = null;
        this.tooltipsToFlush.clear();
        this.tooltipsToFlush = null;
        this.fixedLocationTooltip = null;
        this.infoTooltip = null;
        this.lastTooltipText = null;
        this.lastUnfilteredTooltipText = null;
        this.lastInfoTooltipText = null;
    }

    public void clear(String configKey) {
        if (!configKey.equals("LingeringClickTooltipsOverlay_preferredLocation") && !configKey.equals("LingeringClickTooltipsOverlay_preferredPosition")) {
            this.tooltips.clear();
            this.tooltipsToFlush.clear();
            this.fixedLocationTooltip = null;
        }
        if (!configKey.equals("blacklist") && !configKey.equals("whitelist")) {
            this.lastTooltipText = null;
            this.lastUnfilteredTooltipText = null;
            this.lastInfoTooltipText = null;
        }
    }

    Queue<LingeringClickTooltipsWrapper> getTooltips() {
        return this.tooltips;
    }

    LingeringClickTooltipsWrapper getFixedLocationTooltip() {
        return this.fixedLocationTooltip;
    }

    LingeringClickTooltipsWrapper getInfoTooltip() {
        return this.infoTooltip;
    }

    String getLastUnfilteredTooltipText() {
        return this.lastUnfilteredTooltipText;
    }
}

