/*
 * Decompiled with CFR 0.152.
 */
package ryanxie0.runelite.plugin.lingeringclicktooltips;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.input.MouseListener;
import net.runelite.client.input.MouseManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsConfig;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsInputListener;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsOverlay;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsQueueManager;
import ryanxie0.runelite.plugin.lingeringclicktooltips.color.LingeringClickTooltipsTextColorManager;
import ryanxie0.runelite.plugin.lingeringclicktooltips.filtering.LingeringClickTooltipsTrivialClicksManager;

@PluginDescriptor(name="Lingering Click Tooltips", description="Generate configurable tooltips with left click mouse actions", tags={"overlay", "tooltip", "text", "hover", "click", "action", "toast", "filter"})
public class LingeringClickTooltipsPlugin
extends Plugin {
    @Inject
    private RuneLiteConfig runeLiteConfig;
    @Inject
    private LingeringClickTooltipsConfig config;
    @Inject
    private LingeringClickTooltipsOverlay overlay;
    @Inject
    private MouseManager mouseManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private LingeringClickTooltipsQueueManager queueManager;
    @Inject
    private LingeringClickTooltipsInputListener inputListener;
    @Inject
    private LingeringClickTooltipsTrivialClicksManager trivialClicksManager;
    @Inject
    private LingeringClickTooltipsTextColorManager textColorManager;

    protected void startUp() throws Exception {
        this.mouseManager.registerMouseListener((MouseListener)this.inputListener);
        this.keyManager.registerKeyListener((KeyListener)this.inputListener);
        this.inputListener.initialize(this.queueManager);
        this.queueManager.initialize(this.inputListener);
        this.overlayManager.add((Overlay)this.overlay);
        this.overlay.initialize(this.inputListener, this.queueManager);
        this.trivialClicksManager.initialize();
        this.textColorManager.initialize();
    }

    protected void shutDown() throws Exception {
        this.mouseManager.unregisterMouseListener((MouseListener)this.inputListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.inputListener);
        this.inputListener.destroy();
        this.queueManager.destroy();
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlay.destroy();
        this.trivialClicksManager.destroy();
        this.textColorManager.destroy();
    }

    @Provides
    LingeringClickTooltipsConfig provideConfig(ConfigManager configManager) {
        return (LingeringClickTooltipsConfig)configManager.getConfig(LingeringClickTooltipsConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("lingeringclicktooltips")) {
            this.trivialClicksManager.updateFromConfig(event.getKey());
            this.textColorManager.updateFromConfig(event.getKey());
            this.overlay.updateFromConfig(event.getKey());
            this.queueManager.clear(event.getKey());
        } else if (event.getGroup().equals("runelite")) {
            this.textColorManager.updateFromConfig(event.getKey());
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        this.queueManager.createNewTooltip(event);
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.queueManager.processTick();
    }
}

