/*
 * Decompiled with CFR 0.152.
 */
package ryanxie0.runelite.plugin.lingeringclicktooltips;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Queue;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsConfig;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsInputListener;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsLocation;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsOverlayStateManager;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsPlugin;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsQueueManager;
import ryanxie0.runelite.plugin.lingeringclicktooltips.fade.LingeringClickTooltipsFade;
import ryanxie0.runelite.plugin.lingeringclicktooltips.fade.LingeringClickTooltipsFadeUtil;
import ryanxie0.runelite.plugin.lingeringclicktooltips.renderable.alpha.AlphaTooltipComponent;
import ryanxie0.runelite.plugin.lingeringclicktooltips.wrapper.LingeringClickTooltipsWrapper;
import ryanxie0.runelite.plugin.lingeringclicktooltips.wrapper.LingeringClickTooltipsWrapperUtil;

public class LingeringClickTooltipsOverlay
extends Overlay {
    @Inject
    private LingeringClickTooltipsPlugin plugin;
    @Inject
    private LingeringClickTooltipsConfig config;
    @Inject
    private Client client;
    @Inject
    private TooltipManager tooltipManager;
    private LingeringClickTooltipsInputListener inputListener;
    private LingeringClickTooltipsQueueManager queueManager;
    private LingeringClickTooltipsOverlayStateManager stateManager;

    @Inject
    LingeringClickTooltipsOverlay() {
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
        this.setPriority(OverlayPriority.HIGHEST);
    }

    public Dimension render(Graphics2D graphics) {
        this.stateManager.forceDynamic();
        this.queueManager.flushTooltips();
        this.renderInfoTooltip(this.queueManager.getInfoTooltip(), graphics);
        if (this.config.tooltipLocation() == LingeringClickTooltipsLocation.FIXED) {
            return this.renderFixedLocationTooltip(this.queueManager.getFixedLocationTooltip(), graphics);
        }
        this.renderTooltips(this.queueManager.getTooltips(), graphics);
        return null;
    }

    private Dimension renderFixedLocationTooltip(LingeringClickTooltipsWrapper fixedLocationTooltip, Graphics2D graphics) {
        if (fixedLocationTooltip == null) {
            return null;
        }
        if (fixedLocationTooltip.getRenderableComponent() == null) {
            LingeringClickTooltipsWrapperUtil.buildAlphaTooltipComponent(fixedLocationTooltip, this.client);
        }
        if (fixedLocationTooltip.isFaded()) {
            return fixedLocationTooltip.getRenderableComponent().render(graphics);
        }
        double alphaModifier = this.config.permanentTooltips() || this.config.trackerMode() ? LingeringClickTooltipsFadeUtil.getMaximumOpacity(this.config) : LingeringClickTooltipsFade.calculateAlphaModifier(fixedLocationTooltip, this.config);
        return this.renderTooltip(fixedLocationTooltip, graphics, alphaModifier);
    }

    private void renderTooltips(Queue<LingeringClickTooltipsWrapper> tooltips, Graphics2D graphics) {
        int queuePosition = 0;
        for (LingeringClickTooltipsWrapper tooltip : tooltips) {
            if (tooltip.getRenderableComponent() == null) {
                LingeringClickTooltipsWrapperUtil.buildAlphaTooltipComponent(tooltip, this.client);
            }
            if (!tooltip.isClamped() && tooltip.getLocation() != null) {
                this.clampTooltip(tooltip, graphics);
            }
            if (queuePosition++ < this.config.maximumTooltipsShown()) {
                double alphaModifier = this.config.permanentTooltips() || this.config.trackerMode() ? LingeringClickTooltipsFadeUtil.getMaximumOpacity(this.config) * (double)queuePosition / (double)tooltips.size() : LingeringClickTooltipsFade.calculateAlphaModifier(tooltip, this.config);
                this.renderTooltip(tooltip, graphics, alphaModifier);
            }
            if (!tooltip.isFaded()) continue;
            this.queueManager.addTooltipToFlush(tooltip);
        }
    }

    private void renderInfoTooltip(LingeringClickTooltipsWrapper infoTooltip, Graphics2D graphics) {
        if (infoTooltip != null && !infoTooltip.isFaded()) {
            if (infoTooltip.getRenderableComponent() == null) {
                LingeringClickTooltipsWrapperUtil.buildAlphaTooltipComponent(infoTooltip, this.client);
            }
            this.renderTooltip(infoTooltip, graphics, LingeringClickTooltipsFade.calculateAlphaModifier(infoTooltip, this.config));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Dimension renderTooltip(LingeringClickTooltipsWrapper tooltip, Graphics2D graphics, double alphaModifier) {
        if (!(alphaModifier > 0.0)) {
            tooltip.setFaded(true);
            return null;
        }
        AlphaTooltipComponent renderableComponent = tooltip.getRenderableComponent();
        if (!tooltip.isInfoTooltip() && this.config.tooltipLocation() != LingeringClickTooltipsLocation.ANCHORED && !this.config.trackerMode()) {
            renderableComponent.setAlphaModifier(alphaModifier);
            return renderableComponent.render(graphics);
        }
        renderableComponent.setAlphaModifier(this.inputListener.isMouseOverCanvas() ? alphaModifier : 0.0);
        this.tooltipManager.addFront(new Tooltip((LayoutableRenderableEntity)renderableComponent));
        return null;
    }

    private void clampTooltip(LingeringClickTooltipsWrapper tooltip, Graphics2D graphics) {
        AlphaTooltipComponent renderableComponent = tooltip.getRenderableComponent();
        renderableComponent.setAlphaModifier(0.0);
        Dimension dimension = renderableComponent.render(graphics);
        renderableComponent.setPosition(LingeringClickTooltipsWrapperUtil.getClampedLocation(dimension, tooltip.getLocation(), this.client, this.config));
        tooltip.setClamped(true);
    }

    public void initialize(LingeringClickTooltipsInputListener inputListener, LingeringClickTooltipsQueueManager queueManager) {
        this.inputListener = inputListener;
        this.queueManager = queueManager;
        this.initializeStateManager();
    }

    public void destroy() {
        this.inputListener = null;
        this.queueManager = null;
        this.stateManager.destroy();
        this.stateManager = null;
    }

    private void initializeStateManager() {
        this.stateManager = new LingeringClickTooltipsOverlayStateManager();
        this.stateManager.initialize(this);
        this.updateFromConfig("tooltipLocation");
    }

    public void updateFromConfig(String configKey) {
        if (configKey.equals("tooltipLocation")) {
            if (this.config.tooltipLocation() == LingeringClickTooltipsLocation.FIXED) {
                this.stateManager.load();
            } else {
                if (!this.stateManager.isDynamic()) {
                    this.stateManager.save();
                }
                this.stateManager.setDynamic();
            }
        }
    }
}

