/*
 * Decompiled with CFR 0.152.
 */
package ryanxie0.runelite.plugin.lingeringclicktooltips;

import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.MouseAdapter;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsConfig;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsPlugin;
import ryanxie0.runelite.plugin.lingeringclicktooltips.LingeringClickTooltipsQueueManager;

public class LingeringClickTooltipsInputListener
extends MouseAdapter
implements KeyListener {
    @Inject
    private LingeringClickTooltipsPlugin plugin;
    @Inject
    private LingeringClickTooltipsConfig config;
    private Point lastClickPoint;
    private boolean isCtrlPressed;
    private boolean isShiftPressed;
    private boolean isMouseOverCanvas;
    private boolean isHide;
    private LingeringClickTooltipsQueueManager queueManager;
    private Instant lastCtrlPressTime;
    private Instant lastShiftPressTime;

    public MouseEvent mousePressed(MouseEvent event) {
        if (event.getButton() == 1) {
            this.lastClickPoint = event.getPoint();
        }
        return event;
    }

    public MouseEvent mouseEntered(MouseEvent event) {
        this.isMouseOverCanvas = true;
        return event;
    }

    public MouseEvent mouseExited(MouseEvent event) {
        this.isMouseOverCanvas = false;
        return event;
    }

    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 17) {
            this.processCtrlPressed(event);
        } else if (event.getKeyCode() == 16) {
            this.processShiftPressed(event);
        }
    }

    public void keyReleased(KeyEvent event) {
        if (event.getKeyCode() == 17) {
            this.processCtrlReleased(event);
        } else if (event.getKeyCode() == 16) {
            this.processShiftReleased(event);
        }
    }

    public void keyTyped(KeyEvent event) {
    }

    private void processCtrlPressed(KeyEvent event) {
        if (!this.isCtrlPressed) {
            if (this.lastCtrlPressTime != null && this.config.ctrlDoubleTapDelay() > 0 && Duration.between(this.lastCtrlPressTime, Instant.now()).compareTo(Duration.ofMillis(this.config.ctrlDoubleTapDelay())) < 0) {
                this.isHide = !this.isHide;
                this.queueManager.createHideModeInfoTooltip(this.isHide);
                this.lastCtrlPressTime = null;
            } else {
                this.isCtrlPressed = true;
                this.lastCtrlPressTime = Instant.now();
            }
        }
    }

    private void processShiftPressed(KeyEvent event) {
        if (this.isCtrlPressed) {
            if (!this.isShiftPressed) {
                if (this.lastShiftPressTime != null && this.config.shiftDoubleTapDelay() > 0 && Duration.between(this.lastShiftPressTime, Instant.now()).compareTo(Duration.ofMillis(this.config.shiftDoubleTapDelay())) < 0) {
                    this.queueManager.createFilterListUpdateInfoTooltip();
                    this.lastShiftPressTime = null;
                } else {
                    this.isShiftPressed = true;
                    this.lastShiftPressTime = Instant.now();
                }
            } else if (this.lastShiftPressTime != null && this.config.shiftDoubleTapDelay() > 0 && Duration.between(this.lastShiftPressTime, Instant.now()).compareTo(Duration.ofMillis(this.config.shiftDoubleTapDelay())) > 0 && this.config.shiftPeeks()) {
                this.queueManager.createPeekInfoTooltip();
            }
            event.consume();
        }
    }

    private void processCtrlReleased(KeyEvent event) {
        if (this.isCtrlPressed && this.config.ctrlDoubleTapDelay() > 0 && this.lastCtrlPressTime != null && Duration.between(this.lastCtrlPressTime, Instant.now()).compareTo(Duration.ofMillis(this.config.ctrlDoubleTapDelay())) > 0) {
            this.lastCtrlPressTime = null;
        }
        this.isCtrlPressed = false;
        this.isShiftPressed = false;
    }

    private void processShiftReleased(KeyEvent event) {
        if (this.isCtrlPressed && this.isShiftPressed && this.config.shiftDoubleTapDelay() > 0 && this.lastShiftPressTime != null && Duration.between(this.lastShiftPressTime, Instant.now()).compareTo(Duration.ofMillis(this.config.shiftDoubleTapDelay())) > 0) {
            this.lastShiftPressTime = null;
        }
        this.isShiftPressed = false;
    }

    public void initialize(LingeringClickTooltipsQueueManager queueManager) {
        this.queueManager = queueManager;
        this.isCtrlPressed = false;
        this.isShiftPressed = false;
        this.isMouseOverCanvas = true;
        this.isHide = false;
    }

    public void destroy() {
        this.queueManager = null;
        this.lastCtrlPressTime = null;
        this.lastShiftPressTime = null;
    }

    Point getLastClickPoint() {
        return this.lastClickPoint;
    }

    boolean isCtrlPressed() {
        return this.isCtrlPressed;
    }

    boolean isShiftPressed() {
        return this.isShiftPressed;
    }

    boolean isMouseOverCanvas() {
        return this.isMouseOverCanvas;
    }

    boolean isHide() {
        return this.isHide;
    }
}

