/*
 * Decompiled with CFR 0.152.
 */
package com.discordnotifications;

import com.discordnotifications.DiscordNotificationsConfig;
import com.discordnotifications.DiscordWebhookBody;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.UsernameChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.util.Text;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Discord Notifications")
public class DiscordNotificationsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DiscordNotificationsPlugin.class);
    private Hashtable<String, Integer> currentLevels;
    private ArrayList<String> leveledSkills;
    private boolean shouldSendLevelMessage = false;
    private boolean shouldSendQuestMessage = false;
    private boolean shouldSendClueMessage = false;
    private boolean notificationStarted = false;
    private int ticksWaited = 0;
    private static final Pattern QUEST_PATTERN_1 = Pattern.compile(".+?ve\\.*? (?<verb>been|rebuilt|.+?ed)? ?(?:the )?'?(?<quest>.+?)'?(?: quest)?[!.]?$", 2);
    private static final Pattern QUEST_PATTERN_2 = Pattern.compile("'?(?<quest>.+?)'?(?: quest)? (?<verb>[a-z]\\w+?ed)?(?: f.*?)?[!.]?$", 2);
    private static final ImmutableList<String> RFD_TAGS = ImmutableList.of((Object)"Another Cook", (Object)"freed", (Object)"defeated", (Object)"saved");
    private static final ImmutableList<String> WORD_QUEST_IN_NAME_TAGS = ImmutableList.of((Object)"Another Cook", (Object)"Doric", (Object)"Heroes", (Object)"Legends", (Object)"Observatory", (Object)"Olaf", (Object)"Waterfall");
    private static final Pattern COLLECTION_LOG_ITEM_REGEX = Pattern.compile("New item added to your collection log:.*", 2);
    private static final Pattern COMBAT_TASK_REGEX = Pattern.compile("Congratulations, you've completed an? (?:\\w+) combat task:.*", 2);
    private static final ImmutableList<String> PET_MESSAGES = ImmutableList.of((Object)"You have a funny feeling like you're being followed", (Object)"You feel something weird sneaking into your backpack", (Object)"You have a funny feeling like you would have been followed");
    @Inject
    private Client client;
    @Inject
    private DiscordNotificationsConfig config;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private DrawManager drawManager;

    @Provides
    DiscordNotificationsConfig provideConfig(ConfigManager configManager) {
        return (DiscordNotificationsConfig)configManager.getConfig(DiscordNotificationsConfig.class);
    }

    protected void startUp() throws Exception {
        this.currentLevels = new Hashtable();
        this.leveledSkills = new ArrayList();
    }

    protected void shutDown() throws Exception {
    }

    @Subscribe
    public void onUsernameChanged(UsernameChanged usernameChanged) {
        this.resetState();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState().equals((Object)GameState.LOGIN_SCREEN)) {
            this.resetState();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        boolean didCompleteClue;
        boolean bl = didCompleteClue = this.client.getWidget(WidgetInfo.CLUE_SCROLL_REWARD_ITEM_CONTAINER) != null;
        if (this.shouldSendClueMessage && didCompleteClue && this.config.includeClues()) {
            this.shouldSendClueMessage = false;
            this.sendClueMessage();
        }
        if (this.shouldSendQuestMessage && this.config.includeQuestComplete() && this.client.getWidget(WidgetInfo.QUEST_COMPLETED_NAME_TEXT) != null) {
            this.shouldSendQuestMessage = false;
            String text = this.client.getWidget(WidgetInfo.QUEST_COMPLETED_NAME_TEXT).getText();
            String questName = DiscordNotificationsPlugin.parseQuestCompletedWidget(text);
            this.sendQuestMessage(questName);
        }
        if (!this.shouldSendLevelMessage) {
            return;
        }
        if (this.ticksWaited < 2) {
            ++this.ticksWaited;
            return;
        }
        this.shouldSendLevelMessage = false;
        this.ticksWaited = 0;
        this.sendLevelMessage();
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        if (!this.config.includeLevelling()) {
            return;
        }
        String skillName = statChanged.getSkill().getName();
        int newLevel = statChanged.getLevel();
        Integer previousLevel = this.currentLevels.get(skillName);
        if (previousLevel == null || previousLevel == 0) {
            this.currentLevels.put(skillName, newLevel);
            return;
        }
        if (previousLevel != newLevel) {
            this.currentLevels.put(skillName, newLevel);
            for (int level = previousLevel + 1; level <= newLevel; ++level) {
                if (!this.shouldSendForThisLevel(level)) continue;
                this.leveledSkills.add(skillName);
                this.shouldSendLevelMessage = true;
                break;
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String chatMessage = event.getMessage();
        if (this.config.includePets()) {
            if (PET_MESSAGES.stream().anyMatch(chatMessage::contains)) {
                this.sendPetMessage();
            }
        }
    }

    @Subscribe
    public void onActorDeath(ActorDeath actorDeath) {
        Player player;
        if (!this.config.includeDeaths()) {
            return;
        }
        Actor actor = actorDeath.getActor();
        if (actor instanceof Player && (player = (Player)actor) == this.client.getLocalPlayer()) {
            this.sendDeathMessage();
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        int groupId = event.getGroupId();
        if (groupId == 153) {
            this.shouldSendQuestMessage = true;
        }
        if (groupId == 73) {
            this.shouldSendClueMessage = true;
        }
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired scriptPreFired) {
        switch (scriptPreFired.getScriptId()) {
            case 3346: {
                this.notificationStarted = true;
                break;
            }
            case 3347: {
                if (!this.notificationStarted) {
                    return;
                }
                String topText = this.client.getVarcStrValue(387);
                String bottomText = this.client.getVarcStrValue(388);
                if (topText.equalsIgnoreCase("Collection log") && this.config.includeCollectionLogs() && this.config.sendCollectionLogScreenshot()) {
                    String entry = Text.removeTags((String)bottomText).substring("New item:".length());
                    this.sendCollectionLogMessage(entry);
                }
                if (topText.equalsIgnoreCase("Combat Task Completed!") && this.config.includeCombatAchievements() && this.config.sendCombatAchievementsScreenshot() && this.client.getVarbitValue(12455) == 0) {
                    String[] s = bottomText.split("<.*?>");
                    String task = s[1].replaceAll("[:?]", "");
                    this.sendCombatAchievementMessage(task);
                }
                this.notificationStarted = false;
            }
        }
    }

    private boolean shouldSendForThisLevel(int level) {
        return level >= this.config.minLevel() && this.levelMeetsIntervalRequirement(level);
    }

    private boolean levelMeetsIntervalRequirement(int level) {
        int levelInterval = this.config.levelInterval();
        if (this.config.linearLevelMax() > 0.0) {
            levelInterval = (int)Math.max(Math.ceil(-0.1 * (double)level + this.config.linearLevelMax()), 1.0);
        }
        return levelInterval <= 1 || level == 99 || level % levelInterval == 0;
    }

    private void sendQuestMessage(String questName) {
        String localName = this.client.getLocalPlayer().getName();
        String questMessageString = this.config.questMessage().replaceAll("\\$name", localName).replaceAll("\\$quest", questName);
        DiscordWebhookBody discordWebhookBody = new DiscordWebhookBody();
        discordWebhookBody.setContent(questMessageString);
        this.sendWebhook(discordWebhookBody, this.config.sendQuestingScreenshot());
    }

    private void sendCombatAchievementMessage(String task) {
        String localName = this.client.getLocalPlayer().getName();
        String combatAchievementMessageString = this.config.combatAchievementsMessage().replaceAll("\\$name", localName).replaceAll("\\$achievement", task);
        DiscordWebhookBody discordWebhookBody = new DiscordWebhookBody();
        discordWebhookBody.setContent(combatAchievementMessageString);
        this.sendWebhook(discordWebhookBody, this.config.sendCombatAchievementsScreenshot());
    }

    private void sendCollectionLogMessage(String entry) {
        String localName = this.client.getLocalPlayer().getName();
        String collectionLogMessageString = this.config.collectionLogMessage().replaceAll("\\$name", localName).replaceAll("\\$entry", entry);
        DiscordWebhookBody discordWebhookBody = new DiscordWebhookBody();
        discordWebhookBody.setContent(collectionLogMessageString);
        this.sendWebhook(discordWebhookBody, this.config.sendCollectionLogScreenshot());
    }

    private void sendDeathMessage() {
        String localName = this.client.getLocalPlayer().getName();
        String deathMessageString = this.config.deathMessage().replaceAll("\\$name", localName);
        DiscordWebhookBody discordWebhookBody = new DiscordWebhookBody();
        discordWebhookBody.setContent(deathMessageString);
        this.sendWebhook(discordWebhookBody, this.config.sendDeathScreenshot());
    }

    private void sendClueMessage() {
        String localName = this.client.getLocalPlayer().getName();
        String clueMessage = this.config.clueMessage().replaceAll("\\$name", localName);
        DiscordWebhookBody discordWebhookBody = new DiscordWebhookBody();
        discordWebhookBody.setContent(clueMessage);
        this.sendWebhook(discordWebhookBody, this.config.sendClueScreenshot());
    }

    private void sendLevelMessage() {
        String localName = this.client.getLocalPlayer().getName();
        Object levelUpString = this.config.levelMessage().replaceAll("\\$name", localName);
        String[] skills = new String[this.leveledSkills.size()];
        skills = this.leveledSkills.toArray(skills);
        this.leveledSkills.clear();
        for (int i = 0; i < skills.length; ++i) {
            if (i != 0) {
                levelUpString = (String)levelUpString + this.config.andLevelMessage();
            }
            if (this.config.includeTotalLevel()) {
                levelUpString = (String)levelUpString + this.config.totalLevelMessage();
            }
            String fixed = ((String)levelUpString).replaceAll("\\$skill", skills[i]).replaceAll("\\$level", this.currentLevels.get(skills[i]).toString()).replaceAll("\\$total", Integer.toString(this.client.getTotalLevel()));
            levelUpString = fixed;
        }
        DiscordWebhookBody discordWebhookBody = new DiscordWebhookBody();
        discordWebhookBody.setContent((String)levelUpString);
        this.sendWebhook(discordWebhookBody, this.config.sendLevellingScreenshot());
    }

    private void sendPetMessage() {
        String localName = this.client.getLocalPlayer().getName();
        String petMessageString = this.config.petMessage().replaceAll("\\$name", localName);
        DiscordWebhookBody discordWebhookBody = new DiscordWebhookBody();
        discordWebhookBody.setContent(petMessageString);
        this.sendWebhook(discordWebhookBody, this.config.sendPetScreenshot());
    }

    private void sendWebhook(DiscordWebhookBody discordWebhookBody, boolean sendScreenshot) {
        String configUrl = this.config.webhook();
        if (Strings.isNullOrEmpty((String)configUrl)) {
            return;
        }
        List webhookUrls = Arrays.asList(configUrl.split("\n")).stream().filter(u -> u.length() > 0).map(u -> u.trim()).collect(Collectors.toList());
        for (String webhookUrl : webhookUrls) {
            HttpUrl url = HttpUrl.parse((String)webhookUrl);
            MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", RuneLiteAPI.GSON.toJson((Object)discordWebhookBody));
            if (sendScreenshot) {
                this.sendWebhookWithScreenshot(url, requestBodyBuilder);
                continue;
            }
            this.buildRequestAndSend(url, requestBodyBuilder);
        }
    }

    private void sendWebhookWithScreenshot(HttpUrl url, MultipartBody.Builder requestBodyBuilder) {
        this.drawManager.requestNextFrameListener(image -> {
            byte[] imageBytes;
            BufferedImage bufferedImage = (BufferedImage)image;
            try {
                imageBytes = DiscordNotificationsPlugin.convertImageToByteArray(bufferedImage);
            }
            catch (IOException e) {
                log.warn("Error converting image to byte array", (Throwable)e);
                return;
            }
            requestBodyBuilder.addFormDataPart("file", "image.png", RequestBody.create((MediaType)MediaType.parse((String)"image/png"), (byte[])imageBytes));
            this.buildRequestAndSend(url, requestBodyBuilder);
        });
    }

    private void buildRequestAndSend(HttpUrl url, MultipartBody.Builder requestBodyBuilder) {
        MultipartBody requestBody = requestBodyBuilder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        this.sendRequest(request);
    }

    private void sendRequest(Request request) {
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Error submitting webhook", (Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                response.close();
            }
        });
    }

    private static byte[] convertImageToByteArray(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void resetState() {
        this.currentLevels.clear();
        this.leveledSkills.clear();
        this.shouldSendLevelMessage = false;
        this.shouldSendQuestMessage = false;
        this.shouldSendClueMessage = false;
        this.ticksWaited = 0;
    }

    static String parseQuestCompletedWidget(String text) {
        String verb;
        Matcher questMatchFinal;
        Matcher questMatch1 = QUEST_PATTERN_1.matcher(text);
        Matcher questMatch2 = QUEST_PATTERN_2.matcher(text);
        Matcher matcher = questMatchFinal = questMatch1.matches() ? questMatch1 : questMatch2;
        if (!questMatchFinal.matches()) {
            return "Unable to find quest name!";
        }
        Object quest = questMatchFinal.group("quest");
        String string = verb = questMatchFinal.group("verb") != null ? questMatchFinal.group("verb") : "";
        if (verb.contains("kind of")) {
            quest = (String)quest + " partial completion";
        } else if (verb.contains("completely")) {
            quest = (String)quest + " II";
        }
        if (RFD_TAGS.stream().anyMatch(((String)quest + verb)::contains)) {
            quest = "Recipe for Disaster - " + (String)quest;
        }
        if (WORD_QUEST_IN_NAME_TAGS.stream().anyMatch(((String)quest)::contains)) {
            quest = (String)quest + " Quest";
        }
        return quest;
    }
}

