/*
 * Decompiled with CFR 0.152.
 */
package com.discordnotifications;

import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;

@ConfigGroup(value="discordnotifications")
public interface DiscordNotificationsConfig
extends Config {
    @ConfigSection(name="Webhook Settings", description="The config for webhook content notifications", position=0, closedByDefault=true)
    public static final String webhookConfig = "webhookConfig";
    @ConfigSection(name="Levelling", description="The config for levelling notifications", position=1, closedByDefault=true)
    public static final String levellingConfig = "levellingConfig";
    @ConfigSection(name="Questing", description="The config for questing notifications", position=2, closedByDefault=true)
    public static final String questingConfig = "questingConfig";
    @ConfigSection(name="Deaths", description="The config for death notifications", position=3, closedByDefault=true)
    public static final String deathConfig = "deathConfig";
    @ConfigSection(name="Clue Scrolls", description="The config for clue scroll notifications", position=4, closedByDefault=true)
    public static final String clueConfig = "clueConfig";
    @ConfigSection(name="Pets", description="The config for pet notifications", position=5, closedByDefault=true)
    public static final String petConfig = "petConfig";
    @ConfigSection(name="Collection logs", description="The config for collection logs", position=6, closedByDefault=true)
    public static final String collectionLogsConfig = "collectionLogsConfig";
    @ConfigSection(name="Combat Achievements", description="The config for combat achievements", position=6, closedByDefault=true)
    public static final String combatAchievementsConfig = "combatAchievementsConfig";

    @ConfigItem(keyName="webhook", name="Webhook URL(s)", description="The Discord Webhook URL(s) to send messages to, separated by a newline.", section="webhookConfig", position=0)
    public String webhook();

    @ConfigItem(keyName="includeLevelling", name="Send Levelling Notifications", description="Send messages when you level up a skill.", section="levellingConfig", position=1)
    default public boolean includeLevelling() {
        return false;
    }

    @ConfigItem(keyName="minimumLevel", name="Minimum level", description="Levels greater than or equal to this value will send a message.", section="levellingConfig", position=2)
    default public int minLevel() {
        return 0;
    }

    @ConfigItem(keyName="levelInterval", name="Send every X levels", description="Only levels that are a multiple of this value are sent. Level 99 will always be sent regardless of this value.", section="levellingConfig", position=3)
    default public int levelInterval() {
        return 1;
    }

    @ConfigItem(keyName="linearLevelModifier", name="Linear Level Modifier", description="Send every `max(-.1x + linearLevelMax, 1)` levels. Will override `Send every X levels` if set to above zero.", section="levellingConfig", position=4)
    default public double linearLevelMax() {
        return 0.0;
    }

    @ConfigItem(keyName="levelMessage", name="Level Message", description="Message to send to Discord on Level", section="levellingConfig", position=5)
    default public String levelMessage() {
        return "$name leveled $skill to $level";
    }

    @ConfigItem(keyName="andLevelMessage", name="And Level Message", description="Message to send to Discord when Multi Skill Level", section="levellingConfig", position=6)
    default public String andLevelMessage() {
        return ", and $skill to $level";
    }

    @ConfigItem(keyName="includeTotalLevelMessage", name="Include total level with message", description="Include total level in the message to send to Discord.", section="levellingConfig", position=7)
    default public boolean includeTotalLevel() {
        return false;
    }

    @ConfigItem(keyName="totalLevelMessage", name="Total Level Message", description="Message to send to Discord when Total Level is included.", section="levellingConfig", position=8)
    default public String totalLevelMessage() {
        return " - Total Level: $total";
    }

    @ConfigItem(keyName="sendLevellingScreenshot", name="Include levelling screenshots", description="Include a screenshot when leveling up.", section="levellingConfig", position=100)
    default public boolean sendLevellingScreenshot() {
        return false;
    }

    @ConfigItem(keyName="includeQuests", name="Send Quest Notifications", description="Send messages when you complete a quest.", section="questingConfig")
    default public boolean includeQuestComplete() {
        return false;
    }

    @ConfigItem(keyName="questMessage", name="Quest Message", description="Message to send to Discord on Quest", section="questingConfig", position=1)
    default public String questMessage() {
        return "$name has just completed: $quest";
    }

    @ConfigItem(keyName="sendQuestingScreenshot", name="Include quest screenshots", description="Include a screenshot with the Discord notification when leveling up.", section="questingConfig", position=100)
    default public boolean sendQuestingScreenshot() {
        return false;
    }

    @ConfigItem(keyName="includeDeaths", name="Send Death Notifications", description="Send messages when you die to Discord.", section="deathConfig")
    default public boolean includeDeaths() {
        return false;
    }

    @ConfigItem(keyName="deathMessage", name="Death Message", description="Message to send to Discord on Death", section="deathConfig", position=1)
    default public String deathMessage() {
        return "$name has just died!";
    }

    @ConfigItem(keyName="sendDeathScreenshot", name="Include death screenshots", description="Include a screenshot with the Discord notification when you die.", section="deathConfig", position=100)
    default public boolean sendDeathScreenshot() {
        return false;
    }

    @ConfigItem(keyName="includeClues", name="Send Clue Notifications", description="Send messages when you complete a clue scroll.", section="clueConfig")
    default public boolean includeClues() {
        return false;
    }

    @ConfigItem(keyName="clueMessage", name="Clue Message", description="Message to send to Discord on Clue", section="clueConfig", position=1)
    default public String clueMessage() {
        return "$name has just completed a clue scroll!";
    }

    @ConfigItem(keyName="sendClueScreenshot", name="Include Clue screenshots", description="Include a screenshot with the Discord notification when you complete a clue.", section="clueConfig", position=100)
    default public boolean sendClueScreenshot() {
        return false;
    }

    @ConfigItem(keyName="includePets", name="Send Pet Notifications", description="Send messages when you receive a pet.", section="petConfig")
    default public boolean includePets() {
        return false;
    }

    @ConfigItem(keyName="petMessage", name="Pet Message", description="Message to send to Discord on Pet", section="petConfig", position=1)
    default public String petMessage() {
        return "$name has just received a pet!";
    }

    @ConfigItem(keyName="sendPetScreenshot", name="Include Pet screenshots", description="Include a screenshot with the Discord notification when you receive a pet.", section="petConfig", position=100)
    default public boolean sendPetScreenshot() {
        return false;
    }

    @ConfigItem(keyName="includeCollectionLogs", name="Collection Log Notifications", description="Message to send to Discord on collection logs completions", section="collectionLogsConfig", position=1)
    default public boolean includeCollectionLogs() {
        return false;
    }

    @ConfigItem(keyName="collectionLogMessage", name="Collection log Message", description="Message to send to Discord on collection logs completions", section="collectionLogsConfig", position=2)
    default public String collectionLogMessage() {
        return "$name has just completed a collection log: $entry";
    }

    @ConfigItem(keyName="sendCollectionLogScreenshot", name="Include collection log screenshots", description="Include a screenshot with the Discord notification when you fill a new collection log slot", section="collectionLogsConfig", position=3)
    default public boolean sendCollectionLogScreenshot() {
        return false;
    }

    @ConfigItem(keyName="includeCombatAchievements", name="Combat Achievements Notifications", description="Message to send to Discord on combat achievements completions", section="combatAchievementsConfig", position=1)
    default public boolean includeCombatAchievements() {
        return false;
    }

    @ConfigItem(keyName="combatAchievementsMessage", name="Combat Achievement Message", description="Message to send to Discord on combat achievements completions", section="combatAchievementsConfig", position=2)
    default public String combatAchievementsMessage() {
        return "$name has just completed a combat achievement: $achievement";
    }

    @ConfigItem(keyName="sendCombatAchievementScreenshot", name="Include combat achievements screenshots", description="Include a screenshot with the Discord notification when you complete a combat achievement", section="combatAchievementsConfig", position=100)
    default public boolean sendCombatAchievementsScreenshot() {
        return false;
    }
}

