/*
 * Decompiled with CFR 0.152.
 */
package com.raidsclipboard.raids;

import com.raidsclipboard.data.TobData;
import com.raidsclipboard.raids.Raid;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.ChatMessageType;
import net.runelite.api.GameState;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.Text;

public class Tob
extends Raid {
    private static final int TOB_RAIDERS_VARP = 330;
    private static final int TOB_MAX_SIZE = 5;
    private static final Pattern KC_PATTERN = Pattern.compile("Your completed (.+) count is: (\\d+)\\.");
    private static final Pattern REWARD_PATTERN = Pattern.compile("Your loot is worth around (.*) coins\\.");
    private static final Pattern DEATH_SELF = Pattern.compile("You have died. Death count: \\d+\\.");
    private static final Pattern DEATH_OTHER = Pattern.compile(".* has (?:died|logged out). Death count: \\d+\\.");
    private int tobCurrentDeaths = 0;
    private int currentTobState = 0;

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (this.isInTob() && (event.getType() == ChatMessageType.FRIENDSCHATNOTIFICATION || event.getType() == ChatMessageType.GAMEMESSAGE)) {
            String message = Text.sanitize((String)Text.removeTags((String)event.getMessage()));
            Matcher self = DEATH_SELF.matcher(message);
            Matcher other = DEATH_OTHER.matcher(message);
            if (self.matches() || other.matches()) {
                ++this.tobCurrentDeaths;
                return;
            }
            Matcher matcherKc = KC_PATTERN.matcher(message);
            if (matcherKc.find()) {
                this.raidData.put(TobData.KILL_COUNT, matcherKc.group(2));
                this.raidData.put(TobData.DEATHS, String.valueOf(this.tobCurrentDeaths));
                this.raidData.put(TobData.TEAM_SIZE, this.getTobTeamSize());
                if (!TobData.REWARD.getPattern().matcher(this.config.tobInfoFormat()).find()) {
                    this.handleRaidInfoToClipboard(this.config.tobInfoFormat());
                }
                this.tobCurrentDeaths = 0;
                return;
            }
            Matcher matcherRewards = REWARD_PATTERN.matcher(message);
            if (matcherRewards.find() && TobData.REWARD.getPattern().matcher(this.config.tobInfoFormat()).find()) {
                this.raidData.put(TobData.REWARD, matcherRewards.group(1).replaceAll(",", ""));
                this.handleRaidInfoToClipboard(this.config.tobInfoFormat());
                this.tobCurrentDeaths = 0;
            }
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        int nextState = this.client.getVarbitValue(6440);
        if (this.currentTobState != nextState) {
            if (nextState == 2) {
                this.tobCurrentDeaths = 0;
            }
            this.currentTobState = nextState;
        }
    }

    private boolean isInTob() {
        return this.client.getGameState() == GameState.LOGGED_IN && (this.client.getVarbitValue(6440) == 2 || this.client.getVarbitValue(6440) == 3);
    }

    private String getTobTeamSize() {
        int teamSize = 0;
        Map varcmap = this.client.getVarcMap();
        for (int i = 0; i < 5; ++i) {
            String tName;
            Integer playervarp = 330 + i;
            if (!varcmap.containsKey(playervarp) || (tName = Text.sanitize((String)varcmap.get(playervarp).toString())) == null || tName.equals("")) continue;
            ++teamSize;
        }
        return String.valueOf(teamSize);
    }
}

