/*
 * Decompiled with CFR 0.152.
 */
package com.raidsclipboard.raids;

import com.raidsclipboard.data.ToaData;
import com.raidsclipboard.raids.Raid;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.ChatMessageType;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.Text;

public class Toa
extends Raid {
    private static final int RAID_LEVEL_VAR = 14380;
    private static final int PARTY_SIZE_VAR = 14345;
    private static final Pattern KC_PATTERN = Pattern.compile("Your completed (.+) count is: (\\d+)\\.");
    private static final Pattern ENTRY_PATTERN = Pattern.compile("You enter the Tombs of Amascut");
    private static final Pattern REWARD_PATTERN = Pattern.compile("Your loot is worth around (.*) coins\\.");
    private static final Pattern DEATH_SELF = Pattern.compile("You have died. Total deaths: \\d+\\.");
    private static final Pattern DEATH_OTHER = Pattern.compile(".* has (?:died|logged out). Total deaths: \\d+\\.");
    private static final int WIDGET_PARENT_ID = 481;
    private static final int WIDGET_CHILD_ID = 40;
    private int currentDeaths = 0;

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        String message;
        Matcher entry;
        if (event.getType() == ChatMessageType.GAMEMESSAGE && (entry = ENTRY_PATTERN.matcher(message = Text.sanitize((String)Text.removeTags((String)event.getMessage())))).find()) {
            String raidType = RaidType.NORMAL.name;
            if (message.contains(RaidType.ENTRY.name)) {
                raidType = RaidType.ENTRY.name;
            } else if (message.contains(RaidType.EXPERT.name)) {
                raidType = RaidType.EXPERT.name;
            }
            this.raidData.put(ToaData.RAID_TYPE, raidType);
            this.currentDeaths = 0;
            return;
        }
        if (this.isInToa() && (event.getType() == ChatMessageType.FRIENDSCHATNOTIFICATION || event.getType() == ChatMessageType.GAMEMESSAGE)) {
            message = Text.sanitize((String)Text.removeTags((String)event.getMessage()));
            Matcher self = DEATH_SELF.matcher(message);
            Matcher other = DEATH_OTHER.matcher(message);
            if (self.matches() || other.matches()) {
                ++this.currentDeaths;
                return;
            }
            Matcher matcherKc = KC_PATTERN.matcher(message);
            if (matcherKc.find()) {
                this.raidData.put(ToaData.KILL_COUNT, matcherKc.group(2));
                this.raidData.put(ToaData.DEATHS, String.valueOf(this.currentDeaths));
                int teamSize = this.client.getVarbitValue(14345);
                int raidLvl = this.client.getVarbitValue(14380);
                this.raidData.put(ToaData.TEAM_SIZE, String.valueOf(teamSize));
                this.raidData.put(ToaData.RAID_LEVEL, String.valueOf(raidLvl));
                if (!ToaData.REWARD.getPattern().matcher(this.config.toaInfoFormat()).find()) {
                    this.handleRaidInfoToClipboard(this.config.toaInfoFormat());
                }
                return;
            }
            Matcher matcherRewards = REWARD_PATTERN.matcher(message);
            if (matcherRewards.find() && ToaData.REWARD.getPattern().matcher(this.config.toaInfoFormat()).find()) {
                this.raidData.put(ToaData.REWARD, matcherRewards.group(1).replaceAll(",", ""));
                this.handleRaidInfoToClipboard(this.config.toaInfoFormat());
            }
        }
    }

    private boolean isInToa() {
        Widget w = this.client.getWidget(481, 40);
        return w != null && !w.isHidden();
    }

    static enum RaidType {
        ENTRY("Entry Mode"),
        NORMAL("Normal Mode"),
        EXPERT("Expert Mode");

        private final String name;

        private RaidType(String name) {
            this.name = name;
        }
    }
}

