/*
 * Decompiled with CFR 0.152.
 */
package com.raidsclipboard.raids;

import com.raidsclipboard.data.CoxData;
import com.raidsclipboard.raids.Raid;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.ChatMessageType;
import net.runelite.api.GameState;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.Text;

public class Cox
extends Raid {
    private static final String COMPLETED_MESSAGE = "Congratulations - your raid is complete!";
    private static final Pattern KC_PATTERN = Pattern.compile("Your completed (.+) count is: (\\d+)\\.");

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (this.isInCox() && (event.getType() == ChatMessageType.FRIENDSCHATNOTIFICATION || event.getType() == ChatMessageType.GAMEMESSAGE)) {
            String message = Text.sanitize((String)Text.removeTags((String)event.getMessage()));
            if (message.startsWith(COMPLETED_MESSAGE)) {
                int totalPoints = this.client.getVarbitValue(5431);
                int personalPoints = this.client.getVarbitValue(5422);
                int teamSize = this.client.getVarbitValue(5424);
                this.raidData.put(CoxData.TOTAL_POINTS, String.valueOf(totalPoints));
                this.raidData.put(CoxData.PERSONAL_POINTS, String.valueOf(personalPoints));
                this.raidData.put(CoxData.TEAM_SIZE, String.valueOf(teamSize));
                return;
            }
            Matcher matcher = KC_PATTERN.matcher(message);
            if (matcher.find()) {
                this.raidData.put(CoxData.KILL_COUNT, matcher.group(2));
                this.handleRaidInfoToClipboard(this.config.coxInfoFormat());
            }
        }
    }

    private boolean isInCox() {
        return this.client.getGameState() == GameState.LOGGED_IN && this.client.getVarbitValue(5432) == 1;
    }
}

