/*
 * Decompiled with CFR 0.152.
 */
package com.PvMTickCounter;

import com.PvMTickCounter.TickCounterConfig;
import com.PvMTickCounter.TickCounterOverlay;
import com.google.inject.Provides;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.Hitsplat;
import net.runelite.api.MenuAction;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.kit.KitType;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.OverlayMenuClicked;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PvMTickCounter.TickCounterUtil;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="PvM Tick Counter")
public class TickCounterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TickCounterPlugin.class);
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TickCounterConfig config;
    @Inject
    private Client client;
    private TickCounterUtil id;
    private Integer amount = 0;
    private Integer MHCount = 0;
    private boolean initTime = false;
    private Instant startTime;
    @Inject
    private TickCounterOverlay overlay;
    Map<String, Integer> activity = new HashMap<String, Integer>();
    boolean instanced = false;
    boolean prevInstance = false;

    @Provides
    TickCounterConfig provideConfig(ConfigManager configManager) {
        return (TickCounterConfig)configManager.getConfig(TickCounterConfig.class);
    }

    protected void startUp() throws Exception {
        this.id = new TickCounterUtil();
        this.id.init();
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.activity.clear();
        this.id.clearBP();
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied hitsplatApplied) {
        Player player = this.client.getLocalPlayer();
        Actor actor = hitsplatApplied.getActor();
        if (!(actor instanceof NPC)) {
            return;
        }
        Hitsplat hitsplat = hitsplatApplied.getHitsplat();
        if (hitsplat.isMine()) {
            int hit = hitsplat.getAmount();
            this.amount = this.amount + hit;
        }
        if (hitsplat.isMine() && hitsplat.getHitsplatType() == 43 || hitsplat.getHitsplatType() == 44 || hitsplat.getHitsplatType() == 45 || hitsplat.getHitsplatType() == 46 || hitsplat.getHitsplatType() == 47) {
            Integer n = this.MHCount;
            Integer n2 = this.MHCount = Integer.valueOf(this.MHCount + 1);
        }
    }

    public Integer getDamage() {
        return this.amount;
    }

    public Integer getMH() {
        return this.MHCount;
    }

    public String getDamagePerTick() {
        return String.format("%.2f", Float.valueOf((float)this.amount.intValue() / Float.parseFloat(String.valueOf(this.activity.getOrDefault(this.client.getLocalPlayer().getName(), 0)))));
    }

    public String getDPS() {
        if (this.startTime == null) {
            return "0";
        }
        Instant now = Instant.now();
        long milli = Duration.between(this.startTime, now).toMillis();
        float sec = (float)milli / 1000.0f;
        float dps = (float)this.amount.intValue() / sec;
        return String.format("%.2f", Float.valueOf(dps));
    }

    public String getElapsedTime() {
        if (this.startTime == null || !this.initTime) {
            return null;
        }
        long seconds = Duration.between(this.startTime, Instant.now()).toMillis() / 1000L;
        long HH = seconds / 3600L;
        long MM = seconds % 3600L / 60L;
        long SS = seconds % 60L;
        return String.format("%02d:%02d:%02d", HH, MM, SS);
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged e) {
        if (!(e.getActor() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getActor();
        int weapon = -1;
        if (p.getPlayerComposition() != null) {
            weapon = p.getPlayerComposition().getEquipmentId(KitType.WEAPON);
        }
        int delta = 0;
        delta = this.id.getTicks(p.getAnimation(), weapon, p);
        if (p == this.client.getLocalPlayer() && !this.initTime && this.config.showDPSCalc() && delta > 0) {
            this.initTime = true;
            this.startTime = Instant.now();
        } else if (this.initTime && !this.config.showDPSCalc()) {
            this.initTime = false;
        }
        if (delta > 0) {
            String name = p.getName();
            this.activity.put(name, this.activity.getOrDefault(name, 0) + delta);
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        for (Map.Entry<Player, Boolean> entry : this.id.getBPing().entrySet()) {
            if (entry.getValue().booleanValue()) {
                String name = entry.getKey().getName();
                int activity = this.activity.getOrDefault(name, 0);
                this.activity.put(name, activity + 2);
                this.id.addToBP(entry.getKey(), Boolean.FALSE);
                continue;
            }
            this.id.addToBP(entry.getKey(), Boolean.TRUE);
        }
        if (!this.config.instance()) {
            return;
        }
        this.prevInstance = this.instanced;
        this.instanced = this.client.isInInstancedRegion();
        if (!this.prevInstance && this.instanced) {
            this.activity.clear();
            this.id.clearBP();
            this.amount = 0;
            this.initTime = false;
            this.MHCount = 0;
        }
    }

    @Subscribe
    public void onOverlayMenuClicked(OverlayMenuClicked event) {
        if (event.getEntry().getMenuAction() == MenuAction.RUNELITE_OVERLAY && event.getEntry().getTarget().equals("PvM Tick Counter") && event.getEntry().getOption().equals("Reset")) {
            this.activity.clear();
            this.id.clearBP();
            this.amount = 0;
            this.MHCount = 0;
            this.initTime = false;
        }
    }
}

