/*
 * Decompiled with CFR 0.152.
 */
package com.PvMTickCounter;

import com.PvMTickCounter.TickCounterConfig;
import com.PvMTickCounter.TickCounterPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class TickCounterOverlay
extends OverlayPanel {
    private TickCounterPlugin plugin;
    private TickCounterConfig config;
    private Client client;

    @Inject
    public TickCounterOverlay(TickCounterPlugin plugin, Client client, TickCounterConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPosition(OverlayPosition.DETACHED);
        this.setPosition(OverlayPosition.BOTTOM_RIGHT);
        this.plugin = plugin;
        this.client = client;
        this.config = config;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, "Reset", "PvM Tick Counter"));
    }

    public Dimension render(Graphics2D g) {
        List elems = this.panelComponent.getChildren();
        elems.clear();
        if (this.config.showDamage() && this.plugin.getDamage() > 0) {
            elems.add(TitleComponent.builder().text("Damage Dealt").color(this.config.damageTitleColor()).build());
            elems.add(TitleComponent.builder().text(this.plugin.getDamage().toString()).color(this.config.damageTextColor()).build());
        }
        if (this.config.showMaxHits() && this.plugin.getMH() > 0) {
            elems.add(TitleComponent.builder().text("# Max Hits").color(this.config.MHTitleColor()).build());
            elems.add(TitleComponent.builder().text(this.plugin.getMH().toString()).color(this.config.MHTextColor()).build());
        }
        if (this.config.showDamagePerTick() && (double)Float.parseFloat(this.plugin.getDamagePerTick()) > 0.0) {
            elems.add(TitleComponent.builder().text("Damage/Combat Tick").color(this.config.DPTTitleColor()).build());
            elems.add(TitleComponent.builder().text(this.plugin.getDamagePerTick()).color(this.config.DPTTextColor()).build());
        }
        if (this.config.showDPSCalc() && (double)Float.parseFloat(this.plugin.getDPS()) > 0.0) {
            elems.add(TitleComponent.builder().text("Damage/Second").color(this.config.DPSTitleColor()).build());
            elems.add(TitleComponent.builder().text(this.plugin.getDPS()).color(this.config.DPSTextColor()).build());
        }
        if (this.config.showElapsedTime() && this.plugin.getElapsedTime() != null) {
            elems.add(TitleComponent.builder().text("Elapsed Time").color(this.config.ETTitleColor()).build());
            elems.add(TitleComponent.builder().text(this.plugin.getElapsedTime()).color(this.config.ETTextColor()).build());
        }
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(this.plugin.activity.entrySet());
        list.sort(new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                int value = -Integer.compare(o1.getValue(), o2.getValue());
                if (value == 0) {
                    value = o1.getKey().compareTo(o2.getKey());
                }
                return value;
            }
        });
        if (list.size() != 0) {
            elems.add(TitleComponent.builder().text("Combat Ticks").color(this.config.titleColor()).build());
        }
        int total = 0;
        for (Map.Entry entry : list) {
            total += ((Integer)entry.getValue()).intValue();
            if (((String)entry.getKey()).equals(this.client.getLocalPlayer().getName())) {
                elems.add(LineComponent.builder().leftColor(this.config.selfColor()).rightColor(this.config.selfColor()).left((String)entry.getKey()).right(((Integer)entry.getValue()).toString()).build());
                continue;
            }
            elems.add(LineComponent.builder().left((String)entry.getKey()).right(((Integer)entry.getValue()).toString()).leftColor(this.config.otherColor()).rightColor(this.config.otherColor()).build());
        }
        if (this.config.totalEnabled() && list.size() != 0) {
            elems.add(LineComponent.builder().left("Total").leftColor(this.config.totalColor()).rightColor(this.config.totalColor()).right(String.valueOf(total)).build());
        }
        return super.render(g);
    }
}

