/*
 * Decompiled with CFR 0.152.
 */
package com.grouptileman.runelite.share;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.grouptileman.GroupTilemanAddon;
import com.grouptileman.runelite.config.Tile;
import com.grouptileman.runelite.config.TilesFromUser;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import java.util.TreeMap;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MenuEntry;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.menus.WidgetMenuOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroundMarkerSharingManager {
    private static final Logger log = LoggerFactory.getLogger(GroundMarkerSharingManager.class);
    private static final WidgetMenuOption EXPORT_MARKERS_OPTION = new WidgetMenuOption("Export", "Tileman Markers", WidgetInfo.MINIMAP_WORLDMAP_OPTIONS);
    private static final WidgetMenuOption IMPORT_MARKERS_OPTION = new WidgetMenuOption("Import", "Group Tileman Markers", WidgetInfo.MINIMAP_WORLDMAP_OPTIONS);
    private final GroupTilemanAddon plugin;
    private final Client client;
    private final MenuManager menuManager;
    private final ChatMessageManager chatMessageManager;
    private final ChatboxPanelManager chatboxPanelManager;
    private final Gson gson;
    @Inject
    private ConfigManager configManager;

    @Inject
    private GroundMarkerSharingManager(GroupTilemanAddon plugin, Client client, MenuManager menuManager, ChatMessageManager chatMessageManager, ChatboxPanelManager chatboxPanelManager, Gson gson) {
        this.plugin = plugin;
        this.client = client;
        this.menuManager = menuManager;
        this.chatMessageManager = chatMessageManager;
        this.chatboxPanelManager = chatboxPanelManager;
        this.gson = gson;
    }

    public void addImportExportMenuOptions() {
        this.menuManager.addManagedCustomMenu(EXPORT_MARKERS_OPTION, this::exportTilesFromPlayer);
        this.menuManager.addManagedCustomMenu(IMPORT_MARKERS_OPTION, this::importTilesFromPlayer);
    }

    public void removeMenuOptions() {
        this.menuManager.removeManagedCustomMenu(EXPORT_MARKERS_OPTION);
        this.menuManager.removeManagedCustomMenu(IMPORT_MARKERS_OPTION);
    }

    private void exportTilesFromPlayer(MenuEntry menuEntry) {
        List keys = this.configManager.getConfigurationKeys("tilemanMode");
        TreeMap<String, List<Tile>> regionTiles = new TreeMap<String, List<Tile>>();
        for (String key : keys) {
            if (!key.startsWith("tilemanMode.region_")) continue;
            key = key.replace("tilemanMode.", "");
            regionTiles.put(key, (List)this.gson.fromJson(this.configManager.getConfiguration("tilemanMode", key), new TypeToken<List<Tile>>(){}.getType()));
        }
        String exportDump = this.gson.toJson((Object)new TilesFromUser(this.plugin.getPlayerName(), regionTiles));
        log.debug("Exported ground markers: {}", (Object)exportDump);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(exportDump), null);
    }

    private void importTilesFromPlayer(MenuEntry menuEntry) {
        String clipboardText;
        try {
            clipboardText = Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString();
        }
        catch (UnsupportedFlavorException | IOException ex) {
            this.sendChatMessage("Unable to read system clipboard.");
            log.warn("error reading clipboard", (Throwable)ex);
            return;
        }
        log.debug("Clipboard contents: {}", (Object)clipboardText);
        if (Strings.isNullOrEmpty((String)clipboardText)) {
            this.sendChatMessage("You do not have any ground markers copied in your clipboard.");
            return;
        }
        try {
            TilesFromUser tilesFromUser = (TilesFromUser)this.gson.fromJson(clipboardText, TilesFromUser.class);
            for (String region : tilesFromUser.getRegionTiles().keySet()) {
                this.configManager.setConfiguration("groupTilemanAddon", tilesFromUser.getPlayerName() + "-" + region, this.gson.toJson(tilesFromUser.getRegionTiles().get(region)));
            }
        }
        catch (JsonSyntaxException e) {
            log.debug("Malformed JSON for clipboard import", (Throwable)e);
            this.sendChatMessage("You do not have any ground markers copied in your clipboard.");
        }
    }

    private void sendChatMessage(String message) {
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }
}

