/*
 * Decompiled with CFR 0.152.
 */
package com.grouptileman.runelite.overlay;

import com.grouptileman.GroupTilemanAddon;
import com.grouptileman.runelite.config.Tile;
import com.grouptileman.runelite.config.TilemanModeConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.RenderOverview;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TilemanModeWorldMapOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(TilemanModeWorldMapOverlay.class);
    private static final int REGION_SIZE = 64;
    private static final int REGION_TRUNCATE = -64;
    private final Client client;
    private final TilemanModeConfig config;
    private final GroupTilemanAddon plugin;

    @Inject
    private TilemanModeWorldMapOverlay(Client client, TilemanModeConfig config, GroupTilemanAddon plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGH);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.drawTilesOnWorldMap()) {
            return null;
        }
        this.drawOnWorldMap(graphics);
        return null;
    }

    private void drawOnWorldMap(Graphics2D graphics) {
        RenderOverview ro = this.client.getRenderOverview();
        Widget map = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        Float pixelsPerTile = Float.valueOf(ro.getWorldMapZoom());
        if (map == null) {
            return;
        }
        Rectangle worldMapRect = map.getBounds();
        graphics.setClip(worldMapRect);
        int widthInTiles = (int)Math.ceil(worldMapRect.getWidth() / (double)pixelsPerTile.floatValue());
        int heightInTiles = (int)Math.ceil(worldMapRect.getHeight() / (double)pixelsPerTile.floatValue());
        Point worldMapPosition = ro.getWorldMapPosition();
        int yTileMin = worldMapPosition.getY() - heightInTiles / 2;
        int xRegionMin = worldMapPosition.getX() - widthInTiles / 2 & 0xFFFFFFC0;
        int xRegionMax = (worldMapPosition.getX() + widthInTiles / 2 & 0xFFFFFFC0) + 64;
        int yRegionMin = yTileMin & 0xFFFFFFC0;
        int yRegionMax = (worldMapPosition.getY() + heightInTiles / 2 & 0xFFFFFFC0) + 64;
        int regionPixelSize = (int)Math.ceil(64.0f * pixelsPerTile.floatValue());
        for (int x = xRegionMin; x < xRegionMax; x += 64) {
            for (int y = yRegionMin; y < yRegionMax; y += 64) {
                int regionId = x >> 6 << 8 | y >> 6;
                for (String player : this.config.groupPlayerNames().split(",")) {
                    for (Tile tile : this.plugin.getTiles(player, regionId)) {
                        if (tile.getZ() != this.client.getPlane()) continue;
                        int yTileOffset = -(yTileMin - y) + 2;
                        int xTileOffset = x + widthInTiles / 2 - worldMapPosition.getX();
                        int xPos = (int)((float)xTileOffset * pixelsPerTile.floatValue()) + (int)worldMapRect.getX();
                        int yPos = worldMapRect.height - (int)((float)yTileOffset * pixelsPerTile.floatValue()) + (int)worldMapRect.getY();
                        int size = regionPixelSize / (64 - Math.round(48.0f * ((8.0f - pixelsPerTile.floatValue()) / 7.0f)));
                        int tileSize = regionPixelSize / 64;
                        graphics.setColor(new Color(this.config.markerColor().getRGB()));
                        graphics.fillRect(xPos + tile.getRegionX() * tileSize, yPos - tile.getRegionY() * tileSize + tileSize, size - 1, size - 1);
                        graphics.drawRect(xPos + tile.getRegionX() * tileSize, yPos - tile.getRegionY() * tileSize + tileSize, size - 1, size - 1);
                    }
                }
            }
        }
    }
}

