/*
 * Decompiled with CFR 0.152.
 */
package com.grouptileman.runelite.overlay;

import com.grouptileman.GroupTilemanAddon;
import com.grouptileman.runelite.config.TilemanModeConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TilemanModeOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(TilemanModeOverlay.class);
    private static final int MAX_DRAW_DISTANCE = 32;
    private final Client client;
    private final GroupTilemanAddon plugin;
    @Inject
    private TilemanModeConfig config;

    @Inject
    private TilemanModeOverlay(Client client, TilemanModeConfig config, GroupTilemanAddon plugin) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        List<WorldPoint> points = this.plugin.getPoints();
        for (WorldPoint point : points) {
            if (point.getPlane() != this.client.getPlane()) continue;
            this.drawTile(graphics, point);
        }
        return null;
    }

    private void drawTile(Graphics2D graphics, WorldPoint point) {
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        if (point.distanceTo(playerLocation) >= 32) {
            return;
        }
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)point);
        if (lp == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp);
        if (poly == null) {
            return;
        }
        OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)this.getTileColor());
    }

    private Color getTileColor() {
        return this.config.markerColor();
    }
}

