/*
 * Decompiled with CFR 0.152.
 */
package com.grouptileman.runelite.overlay;

import com.grouptileman.GroupTilemanAddon;
import com.grouptileman.runelite.config.TilemanModeConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TilemanModeMinimapOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(TilemanModeMinimapOverlay.class);
    private static final int MAX_DRAW_DISTANCE = 16;
    private static final int TILE_WIDTH = 4;
    private static final int TILE_HEIGHT = 4;
    private final Client client;
    private final TilemanModeConfig config;
    private final GroupTilemanAddon plugin;

    @Inject
    private TilemanModeMinimapOverlay(Client client, TilemanModeConfig config, GroupTilemanAddon plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.drawTilesOnMinimap()) {
            return null;
        }
        List<WorldPoint> points = this.plugin.getPoints();
        for (WorldPoint point : points) {
            WorldPoint worldPoint = point;
            if (worldPoint.getPlane() != this.client.getPlane()) continue;
            this.drawOnMinimap(graphics, worldPoint);
        }
        return null;
    }

    private void drawOnMinimap(Graphics2D graphics, WorldPoint point) {
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        if (point.distanceTo(playerLocation) >= 16) {
            return;
        }
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)point);
        if (lp == null) {
            return;
        }
        Point posOnMinimap = Perspective.localToMinimap((Client)this.client, (LocalPoint)lp);
        if (posOnMinimap == null) {
            return;
        }
        OverlayUtil.renderMinimapRect((Client)this.client, (Graphics2D)graphics, (Point)posOnMinimap, (int)4, (int)4, (Color)this.getTileColor());
    }

    private Color getTileColor() {
        return this.config.markerColor();
    }
}

