/*
 * Decompiled with CFR 0.152.
 */
package com.grouptileman;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import com.grouptileman.runelite.config.Tile;
import com.grouptileman.runelite.config.TilemanModeConfig;
import com.grouptileman.runelite.overlay.TilemanModeMinimapOverlay;
import com.grouptileman.runelite.overlay.TilemanModeOverlay;
import com.grouptileman.runelite.overlay.TilemanModeWorldMapOverlay;
import com.grouptileman.runelite.share.GroundMarkerSharingManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Group tileman addon", description="Automatically share and draw group tiles", tags={"overlay", "tiles"})
public class GroupTilemanAddon
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GroupTilemanAddon.class);
    public static final String CONFIG_GROUP = "groupTilemanAddon";
    public static final String TILEMAN_CONFIG_GROUP = "tilemanMode";
    public static final String REGION_PREFIX = "region_";
    private static final Gson GSON = new Gson();
    private final List<WorldPoint> points = new ArrayList<WorldPoint>();
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TilemanModeOverlay overlay;
    @Inject
    private TilemanModeMinimapOverlay minimapOverlay;
    @Inject
    private TilemanModeWorldMapOverlay worldMapOverlay;
    @Inject
    private TilemanModeConfig config;
    @Inject
    private GroundMarkerSharingManager sharing;
    @Inject
    private ClientToolbar clientToolbar;

    @Provides
    TilemanModeConfig provideConfig(ConfigManager configManager) {
        return (TilemanModeConfig)configManager.getConfig(TilemanModeConfig.class);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        this.reloadPoints();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        this.reloadPoints();
    }

    private void reloadPoints() {
        this.points.clear();
        int[] regions = this.client.getMapRegions();
        if (regions == null) {
            return;
        }
        for (String player : this.config.groupPlayerNames().split(",")) {
            for (int regionId : regions) {
                log.debug("Loading points for region {}", (Object)regionId);
                Collection<WorldPoint> worldPoint = this.translateToWorldPoint(this.getTiles(player, regionId));
                this.points.addAll(worldPoint);
            }
        }
    }

    protected void startUp() {
        log.error("startUp");
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.minimapOverlay);
        this.overlayManager.add((Overlay)this.worldMapOverlay);
        this.sharing.addImportExportMenuOptions();
        this.reloadPoints();
    }

    protected void shutDown() {
        log.error("shutDown");
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.minimapOverlay);
        this.overlayManager.remove((Overlay)this.worldMapOverlay);
        this.points.clear();
        this.sharing.removeMenuOptions();
    }

    public String getPlayerName() {
        return this.client.getLocalPlayer() != null && this.client.getLocalPlayer().getName() != null ? this.client.getLocalPlayer().getName() : "";
    }

    public Collection<Tile> getTiles(String player, int regionId) {
        if (player == null || player.isEmpty()) {
            throw new NullPointerException("Empty player");
        }
        return this.getConfiguration(player + "-region_" + regionId);
    }

    private Collection<Tile> getTiles(String player, String regionId) {
        if (player == null || player.isEmpty()) {
            throw new NullPointerException("Empty player");
        }
        return this.getConfiguration(player + "-region_" + regionId);
    }

    private Collection<Tile> getConfiguration(String key) {
        String json = this.configManager.getConfiguration(CONFIG_GROUP, key);
        if (Strings.isNullOrEmpty((String)json)) {
            return Collections.emptyList();
        }
        return (Collection)GSON.fromJson(json, new TypeToken<List<Tile>>(){}.getType());
    }

    private Collection<WorldPoint> translateToWorldPoint(Collection<Tile> points) {
        if (points.isEmpty()) {
            return Collections.emptyList();
        }
        return points.stream().map(point -> WorldPoint.fromRegion((int)point.getRegionId(), (int)point.getRegionX(), (int)point.getRegionY(), (int)point.getZ())).flatMap(worldPoint -> {
            Collection localWorldPoints = WorldPoint.toLocalInstance((Client)this.client, (WorldPoint)worldPoint);
            return localWorldPoints.stream();
        }).collect(Collectors.toList());
    }

    public List<WorldPoint> getPoints() {
        return this.points;
    }
}

