/*
 * Decompiled with CFR 0.152.
 */
package com.levelupquestreqs.questmaps.quests;

import java.util.EnumMap;
import java.util.Map;
import net.runelite.api.Quest;
import net.runelite.api.Skill;

public abstract class BaseQuestSkillMap {
    protected Quest quest;
    protected Map<Skill, Integer> skillReqs = new EnumMap<Skill, Integer>(Skill.class);

    public boolean newSkillLevelMeetsRequirements(Map<Skill, Integer> previousLevels, Skill skillLevelled, Integer newLevel) {
        if (newLevel != this.skillReqs.getOrDefault(skillLevelled, 99)) {
            return false;
        }
        Map<Skill, Integer> otherSkillReqs = this.skillReqs;
        otherSkillReqs.remove(skillLevelled);
        if (!otherSkillReqs.isEmpty()) {
            for (Map.Entry<Skill, Integer> reqEntry : otherSkillReqs.entrySet()) {
                if (previousLevels.getOrDefault(reqEntry.getKey(), -1) >= reqEntry.getValue()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasSkillAsRequirement(Skill skill) {
        return this.skillReqs.containsKey(skill);
    }

    public Quest getQuest() {
        return this.quest;
    }
}

