/*
 * Decompiled with CFR 0.152.
 */
package com.levelupquestreqs;

import com.levelupquestreqs.LevelUpQuestReqsInterfaceInput;
import com.levelupquestreqs.questmaps.IgnoredQuests;
import com.levelupquestreqs.questmaps.QuestSkillMaps;
import com.levelupquestreqs.skillmaps.MaxSkillRequirements;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Quest;
import net.runelite.api.Skill;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.StatChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.chatbox.ChatboxInput;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Level Up Quest Requirements", description="Displays a dialog on levelling up when you first reach the requirements for a quest.", tags={"quest", "requirements", "req", "reqs", "level", "levels"}, enabledByDefault=true)
public class LevelUpQuestReqsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LevelUpQuestReqsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    private final QuestSkillMaps questSkillMaps = new QuestSkillMaps(this);
    private final Map<Skill, Integer> previousLevelMap = new EnumMap<Skill, Integer>(Skill.class);
    private final List<Quest> incompleteQuestsList = new ArrayList<Quest>();
    private final List<Quest> newQuestReqsMet = new ArrayList<Quest>();
    private boolean loggingIn;
    private LevelUpQuestReqsInterfaceInput input;
    private static final Integer rfdBaseQuestVarbit = 1850;

    protected void startUp() throws Exception {
        IgnoredQuests.initialise();
        MaxSkillRequirements.initialise();
        log.info("Level Up Quest Requirements started!");
    }

    protected void shutDown() throws Exception {
        if (this.input != null && this.chatboxPanelManager.getCurrentInput() == this.input) {
            this.chatboxPanelManager.close();
        }
        this.previousLevelMap.clear();
        this.incompleteQuestsList.clear();
        this.newQuestReqsMet.clear();
        this.input = null;
        log.info("Level Up Quest Requirements stopped!");
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGING_IN) {
            this.previousLevelMap.clear();
            this.loggingIn = true;
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.loggingIn) {
            this.loggingIn = false;
            this.initialisePreviousLevelMap();
            this.initialiseIncompleteQuestList();
        }
        if (this.input != null) {
            this.input.closeIfTriggered();
        }
        if (this.newQuestReqsMet.isEmpty() || !this.chatboxPanelManager.getContainerWidget().isHidden()) {
            return;
        }
        Quest quest = this.newQuestReqsMet.remove(0);
        this.input = new LevelUpQuestReqsInterfaceInput(this, quest);
        this.chatboxPanelManager.openInput((ChatboxInput)this.input);
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        Skill skill = statChanged.getSkill();
        int skillLevelBefore = this.previousLevelMap.getOrDefault(skill, -1);
        if (statChanged.getLevel() == skillLevelBefore) {
            return;
        }
        if (statChanged.getLevel() > MaxSkillRequirements.getMaxLevelForSkill(skill)) {
            return;
        }
        List<Quest> questRequirementsReached = this.questSkillMaps.getQuestsFulfilledByLevel(this.previousLevelMap, skill, statChanged.getLevel());
        this.previousLevelMap.replace(skill, statChanged.getLevel());
        if (questRequirementsReached.isEmpty()) {
            return;
        }
        this.newQuestReqsMet.addAll(questRequirementsReached);
    }

    private void initialisePreviousLevelMap() {
        for (Skill skill : Skill.values()) {
            if (skill.getName() == "Overall") {
                return;
            }
            this.previousLevelMap.put(skill, this.client.getRealSkillLevel(skill));
        }
        log.info("Skill levels loaded!");
    }

    private void initialiseIncompleteQuestList() {
        Quest[] quests;
        block3: for (Quest quest2 : quests = (Quest[])Arrays.stream(Quest.values()).filter(quest -> !IgnoredQuests.isIgnored(quest)).toArray(Quest[]::new)) {
            if (quest2.getName().contains("Recipe for Disaster")) {
                if (this.isRFDSubquestComplete(quest2)) continue;
                this.incompleteQuestsList.add(quest2);
                continue;
            }
            switch (this.getQuestStatus(quest2.getId())) {
                case 2: {
                    continue block3;
                }
                default: {
                    this.incompleteQuestsList.add(quest2);
                }
            }
        }
        log.info("Found " + this.incompleteQuestsList.toArray().length + " incomplete quests!");
    }

    private Integer getQuestStatus(Integer questId) {
        this.client.runScript(new Object[]{4029, questId});
        return this.client.getIntStack()[0];
    }

    private boolean isRFDSubquestComplete(Quest quest) {
        Integer questVarbit = this.getQuestVarbitForRFDSubquest(quest);
        switch (quest) {
            case RECIPE_FOR_DISASTER__ANOTHER_COOKS_QUEST: {
                return this.client.getVarbitValue(rfdBaseQuestVarbit.intValue()) >= 3;
            }
            case RECIPE_FOR_DISASTER__MOUNTAIN_DWARF: {
                return this.client.getVarbitValue(questVarbit.intValue()) >= 60 || this.client.getVarbitValue(rfdBaseQuestVarbit.intValue()) < 3;
            }
            case RECIPE_FOR_DISASTER__WARTFACE__BENTNOZE: {
                return this.client.getVarbitValue(questVarbit.intValue()) >= 40 || this.client.getVarbitValue(rfdBaseQuestVarbit.intValue()) < 3;
            }
            case RECIPE_FOR_DISASTER__PIRATE_PETE: {
                return this.client.getVarbitValue(questVarbit.intValue()) >= 110 || this.client.getVarbitValue(rfdBaseQuestVarbit.intValue()) < 3;
            }
            case RECIPE_FOR_DISASTER__LUMBRIDGE_GUIDE: 
            case RECIPE_FOR_DISASTER__EVIL_DAVE: {
                return this.client.getVarbitValue(questVarbit.intValue()) >= 5 || this.client.getVarbitValue(rfdBaseQuestVarbit.intValue()) < 3;
            }
            case RECIPE_FOR_DISASTER__SIR_AMIK_VARZE: {
                return this.client.getVarbitValue(questVarbit.intValue()) >= 20 || this.client.getVarbitValue(rfdBaseQuestVarbit.intValue()) < 3;
            }
            case RECIPE_FOR_DISASTER__SKRACH_UGLOGWEE: {
                return this.client.getVarbitValue(questVarbit.intValue()) >= 170 || this.client.getVarbitValue(rfdBaseQuestVarbit.intValue()) < 3;
            }
            case RECIPE_FOR_DISASTER__KING_AWOWOGEI: {
                return this.client.getVarbitValue(questVarbit.intValue()) >= 50 || this.client.getVarbitValue(rfdBaseQuestVarbit.intValue()) < 3;
            }
        }
        return true;
    }

    private Integer getQuestVarbitForRFDSubquest(Quest quest) {
        switch (quest) {
            case RECIPE_FOR_DISASTER__ANOTHER_COOKS_QUEST: 
            case RECIPE_FOR_DISASTER: 
            case RECIPE_FOR_DISASTER__CULINAROMANCER: {
                return rfdBaseQuestVarbit;
            }
            case RECIPE_FOR_DISASTER__MOUNTAIN_DWARF: {
                return 1892;
            }
            case RECIPE_FOR_DISASTER__WARTFACE__BENTNOZE: {
                return 1867;
            }
            case RECIPE_FOR_DISASTER__PIRATE_PETE: {
                return 1895;
            }
            case RECIPE_FOR_DISASTER__LUMBRIDGE_GUIDE: {
                return 1896;
            }
            case RECIPE_FOR_DISASTER__EVIL_DAVE: {
                return 1878;
            }
            case RECIPE_FOR_DISASTER__SIR_AMIK_VARZE: {
                return 1910;
            }
            case RECIPE_FOR_DISASTER__SKRACH_UGLOGWEE: {
                return 1904;
            }
            case RECIPE_FOR_DISASTER__KING_AWOWOGEI: {
                return 1914;
            }
        }
        return -1;
    }

    Client getClient() {
        return this.client;
    }

    ClientThread getClientThread() {
        return this.clientThread;
    }

    ChatboxPanelManager getChatboxPanelManager() {
        return this.chatboxPanelManager;
    }

    public List<Quest> getIncompleteQuestsList() {
        return this.incompleteQuestsList;
    }
}

