/*
 * Decompiled with CFR 0.152.
 */
package com.levelupquestreqs;

import com.levelupquestreqs.LevelUpQuestReqsPlugin;
import java.awt.Color;
import java.awt.event.KeyEvent;
import net.runelite.api.Quest;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.game.chatbox.ChatboxInput;
import net.runelite.client.input.KeyListener;
import net.runelite.client.util.ColorUtil;

public class LevelUpQuestReqsInterfaceInput
extends ChatboxInput
implements KeyListener {
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 16;
    private final LevelUpQuestReqsPlugin plugin;
    private final Quest quest;
    private boolean closeMessage;

    LevelUpQuestReqsInterfaceInput(LevelUpQuestReqsPlugin plugin, Quest quest) {
        this.plugin = plugin;
        this.quest = quest;
    }

    public void open() {
        Widget chatboxContainer = this.plugin.getChatboxPanelManager().getContainerWidget();
        String questName = this.quest.getName().contains("Recipe for Disaster") ? this.quest.getName().replace("Recipe for Disaster", "RFD") : this.quest.getName();
        Widget questReqLine1 = chatboxContainer.createChild(-1, 4);
        Widget questReqLine2 = chatboxContainer.createChild(-1, 4);
        Widget questReqContinue = chatboxContainer.createChild(-1, 4);
        questReqLine1.setText("Congratulations, you just reached the skill");
        questReqLine1.setTextColor(Color.BLACK.getRGB());
        questReqLine1.setFontId(497);
        questReqLine1.setXPositionMode(0);
        questReqLine1.setOriginalX(86);
        questReqLine1.setYPositionMode(0);
        questReqLine1.setOriginalY(31);
        questReqLine1.setOriginalWidth(390);
        questReqLine1.setOriginalHeight(30);
        questReqLine1.setXTextAlignment(1);
        questReqLine1.setYTextAlignment(0);
        questReqLine1.setWidthMode(0);
        questReqLine1.revalidate();
        questReqLine2.setText("requirements to complete " + ColorUtil.wrapWithColorTag((String)questName, (Color)Color.RED) + ".");
        questReqLine2.setTextColor(Color.BLACK.getRGB());
        questReqLine2.setFontId(497);
        questReqLine2.setXPositionMode(0);
        questReqLine2.setOriginalX(86);
        questReqLine2.setYPositionMode(0);
        questReqLine2.setOriginalY(46);
        questReqLine2.setOriginalWidth(390);
        questReqLine2.setOriginalHeight(30);
        questReqLine2.setXTextAlignment(1);
        questReqLine2.setYTextAlignment(0);
        questReqLine2.setWidthMode(0);
        questReqLine2.revalidate();
        questReqContinue.setText("Click here to continue");
        questReqContinue.setTextColor(Color.BLUE.getRGB());
        questReqContinue.setFontId(497);
        questReqContinue.setXPositionMode(0);
        questReqContinue.setOriginalX(86);
        questReqContinue.setYPositionMode(0);
        questReqContinue.setOriginalY(90);
        questReqContinue.setOriginalWidth(390);
        questReqContinue.setOriginalHeight(17);
        questReqContinue.setXTextAlignment(1);
        questReqContinue.setYTextAlignment(0);
        questReqContinue.setWidthMode(0);
        questReqContinue.setAction(0, "Continue");
        questReqContinue.setOnOpListener(new Object[]{ev -> this.triggerCloseViaMessage()});
        questReqContinue.setOnMouseOverListener(new Object[]{ev -> questReqContinue.setTextColor(Color.WHITE.getRGB())});
        questReqContinue.setOnMouseLeaveListener(new Object[]{ev -> questReqContinue.setTextColor(Color.BLUE.getRGB())});
        questReqContinue.setHasListener(true);
        questReqContinue.revalidate();
        LevelUpQuestReqsInterfaceInput.buildSpriteWidget(chatboxContainer, true);
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() != ' ') {
            return;
        }
        this.triggerCloseViaMessage();
        e.consume();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    void closeIfTriggered() {
        if (this.closeMessage && this.plugin.getChatboxPanelManager().getCurrentInput() == this) {
            this.plugin.getChatboxPanelManager().close();
        }
    }

    void triggerClose() {
        this.closeMessage = true;
    }

    private void triggerCloseViaMessage() {
        Widget questReqContinue = this.plugin.getClient().getWidget(WidgetInfo.CHATBOX_CONTAINER).getChild(2);
        questReqContinue.setText("Please wait...");
        this.closeMessage = true;
    }

    private static void buildSpriteWidget(Widget chatboxContainer, boolean isQuest) {
        Widget questReqSprite = chatboxContainer.createChild(-1, 5);
        questReqSprite.setSpriteId(isQuest ? 776 : 1299);
        questReqSprite.setXPositionMode(0);
        questReqSprite.setOriginalX(13);
        questReqSprite.setYPositionMode(0);
        questReqSprite.setOriginalY(10);
        questReqSprite.setOriginalWidth(99);
        questReqSprite.setOriginalHeight(108);
        questReqSprite.revalidate();
    }

    public boolean isCloseMessage() {
        return this.closeMessage;
    }
}

