/*
 * Decompiled with CFR 0.152.
 */
package com.cluehunterfinder;

import com.cluehunterfinder.ClueHunterItem;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;

public class CommandHandler {
    private final Client client;

    @Inject
    CommandHandler(Client client) {
        this.client = client;
    }

    ClueHunterItem getItemForCommand(String itemDescriptor) {
        ClueHunterItem item = ClueHunterItem.getClueHunterItemMap().get(itemDescriptor);
        if (item == null || this.hasClueHunterItems(item.getId())) {
            return null;
        }
        return item;
    }

    private boolean hasClueHunterItems(int id) {
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        ItemContainer bank = this.client.getItemContainer(InventoryID.BANK);
        ItemContainer equipment = this.client.getItemContainer(InventoryID.EQUIPMENT);
        return inventory != null && inventory.contains(id) || bank != null && bank.contains(id) || equipment != null && equipment.contains(id);
    }
}

