/*
 * Decompiled with CFR 0.152.
 */
package com.cluehunterfinder;

import java.util.HashMap;
import java.util.Map;
import net.runelite.api.coords.WorldPoint;

public enum ClueHunterItem {
    CLUE_HUNTER_BOOTS(new WorldPoint(2580, 3377, 0), 19695, "chboots", "Dig next to an oak tree south-west of the Fishing Guild, just north of East Ardougne."),
    CLUE_HUNTER_GLOVES(new WorldPoint(2580, 3377, 0), 19691, "chgloves", "Dig next to an oak tree south-west of the Fishing Guild, just north of East Ardougne."),
    CLUE_HUNTER_GARB(new WorldPoint(1595, 3626, 0), 19689, "chgarb", "Dig just north-east of the Shayzien minecart station."),
    CLUE_HUNTER_TROUSERS(new WorldPoint(2819, 3126, 0), 19693, "chtrousers", "Dig near the entrance to the Pothole Dungeon north of Tai Bwo Wannai."),
    CLUE_HUNTER_CLOAK(new WorldPoint(2614, 3064, 0), 19697, "chcloak", "Dig between two willow trees south-east of Yanille."),
    HELM_OF_RAEDWALD(new WorldPoint(2590, 3231, 0), 19687, "helmor", "Dig near the iron rocks by the cave entrance east of the Clock Tower. Requires 1 nature rune, 1 superantipoison(1) and leather boots.");

    private final WorldPoint location;
    private final int id;
    private final String findInstruction;
    private final String keyword;
    private static final Map<String, ClueHunterItem> itemMap;

    private ClueHunterItem(WorldPoint location, int id, String keyword, String findInstruction) {
        this.location = location;
        this.id = id;
        this.keyword = keyword;
        this.findInstruction = findInstruction;
    }

    static Map<String, ClueHunterItem> getClueHunterItemMap() {
        return itemMap;
    }

    private static Map<String, ClueHunterItem> generateClueHunterItemMap() {
        HashMap<String, ClueHunterItem> map = new HashMap<String, ClueHunterItem>();
        for (ClueHunterItem item : ClueHunterItem.values()) {
            map.put(item.keyword, item);
        }
        return map;
    }

    public WorldPoint getLocation() {
        return this.location;
    }

    public int getId() {
        return this.id;
    }

    public String getFindInstruction() {
        return this.findInstruction;
    }

    static {
        itemMap = ClueHunterItem.generateClueHunterItemMap();
    }
}

