/*
 * Decompiled with CFR 0.152.
 */
package com.cluehunterfinder;

import com.cluehunterfinder.ClueHunterFinderConfig;
import com.cluehunterfinder.ClueHunterFinderHintArrow;
import com.cluehunterfinder.ClueHunterFinderOverlay;
import com.cluehunterfinder.ClueHunterItem;
import com.cluehunterfinder.CommandHandler;
import com.google.inject.Provides;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Item;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.CommandExecuted;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Clue Hunter Finder")
public class ClueHunterFinderPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ClueHunterFinderPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClueHunterFinderConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private WorldMapPointManager worldMapPointManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClueHunterFinderOverlay overlay;
    @Inject
    private CommandHandler handler;
    @Inject
    private ClueHunterFinderHintArrow hintArrow;
    private ClueHunterItem itemToFind;

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() {
        this.itemToFind = null;
        this.hintArrow.clear();
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        List<Item> items = Arrays.asList(event.getItemContainer().getItems());
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        for (ClueHunterItem item : ClueHunterItem.values()) {
            if (!playerLocation.equals((Object)item.getLocation()) && !items.contains(item.getId())) continue;
            this.itemToFind = null;
            this.hintArrow.clear();
            return;
        }
    }

    @Subscribe
    void onCommandExecuted(CommandExecuted command) {
        if (command.getCommand().contentEquals("find")) {
            String[] arguments = command.getArguments();
            this.itemToFind = this.handler.getItemForCommand(arguments[0]);
            if (this.itemToFind == null) {
                this.hintArrow.clear();
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.itemToFind != null) {
            this.hintArrow.setArrow(this.itemToFind.getLocation());
        }
    }

    @Provides
    ClueHunterFinderConfig provideConfig(ConfigManager configManager) {
        return (ClueHunterFinderConfig)configManager.getConfig(ClueHunterFinderConfig.class);
    }

    public ClueHunterItem getItemToFind() {
        return this.itemToFind;
    }
}

