/*
 * Decompiled with CFR 0.152.
 */
package com.cluehunterfinder;

import com.cluehunterfinder.ClueHunterFinderPlugin;
import com.cluehunterfinder.ClueHunterItem;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClueHunterFinderOverlay
extends OverlayPanel {
    private static final Logger log = LoggerFactory.getLogger(ClueHunterFinderOverlay.class);
    private final ClueHunterFinderPlugin plugin;
    private final ItemManager itemManager;

    @Inject
    private ClueHunterFinderOverlay(ClueHunterFinderPlugin plugin, ItemManager itemManager) {
        this.plugin = plugin;
        this.itemManager = itemManager;
    }

    public Dimension render(Graphics2D graphics) {
        ClueHunterItem item = this.plugin.getItemToFind();
        if (item == null) {
            return null;
        }
        String titleText = this.itemManager.getItemComposition(item.getId()).getName();
        this.panelComponent.getChildren().add(TitleComponent.builder().text(titleText).build());
        this.panelComponent.getChildren().add(LineComponent.builder().build());
        this.panelComponent.getChildren().add(LineComponent.builder().left(item.getFindInstruction()).build());
        return super.render(graphics);
    }
}

