/*
 * Decompiled with CFR 0.152.
 */
package com.cluehunterfinder;

import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClueHunterFinderHintArrow {
    private static final Logger log = LoggerFactory.getLogger(ClueHunterFinderHintArrow.class);
    private static final int MIN_DRAW_DISTANCE = 64;
    private final Client client;

    @Inject
    ClueHunterFinderHintArrow(Client client) {
        this.client = client;
    }

    void setArrow(WorldPoint target) {
        this.clear();
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        WorldPoint nextWorldPoint = this.computeNextWorldPoint(target, this.client.getLocalPlayer().getWorldLocation());
        this.client.setHintArrow(nextWorldPoint);
    }

    void clear() {
        this.client.clearHintArrow();
    }

    private WorldPoint computeNextWorldPoint(WorldPoint target, WorldPoint current) {
        int distance = current.distanceTo(target);
        double distanceRatio = 64.0 / (double)distance;
        if (distanceRatio >= 1.0) {
            return target;
        }
        int nextWorldPointX = (int)Math.floor((double)(target.getX() - current.getX()) * distanceRatio) + current.getX();
        int nextWorldPointY = (int)Math.floor((double)(target.getY() - current.getY()) * distanceRatio) + current.getY();
        return new WorldPoint(nextWorldPointX, nextWorldPointY, 0);
    }
}

