/*
 * Decompiled with CFR 0.152.
 */
package com.cdfisher.focusmute;

import com.cdfisher.focusmute.FocusMuteConfig;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.FocusChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Focus Mute")
public class FocusMutePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(FocusMutePlugin.class);
    static final String CONFIG_GROUP = "focusmute";
    boolean muteMusic;
    boolean muteSoundEffects;
    boolean muteAreaSounds;
    private int musicVolume;
    private int soundEffectVolume;
    private int areaSoundEffectVolume;
    private int initialMusicVolume;
    private int initialSoundEffectVolume;
    private int initialAreaSoundEffectVolume;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private FocusMuteConfig config;

    protected void startUp() throws Exception {
        log.info("Focus mute started!");
        this.loadOptions();
        this.clientThread.invoke(() -> {
            this.initialMusicVolume = this.client.getMusicVolume();
            this.initialSoundEffectVolume = this.client.getPreferences().getSoundEffectVolume();
            this.initialAreaSoundEffectVolume = this.client.getPreferences().getAreaSoundEffectVolume();
        });
    }

    protected void shutDown() throws Exception {
        this.clientThread.invoke(() -> {
            this.client.setMusicVolume(this.initialMusicVolume);
            this.client.getPreferences().setSoundEffectVolume(this.initialSoundEffectVolume);
            this.client.getPreferences().setAreaSoundEffectVolume(this.initialAreaSoundEffectVolume);
        });
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!CONFIG_GROUP.equals(event.getGroup())) {
            return;
        }
        this.loadOptions();
        this.refreshMutes();
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (!chatMessage.getType().equals((Object)ChatMessageType.WELCOME)) {
            return;
        }
        this.clientThread.invoke(() -> {
            this.initialMusicVolume = this.client.getMusicVolume();
            this.initialSoundEffectVolume = this.client.getPreferences().getSoundEffectVolume();
            this.initialAreaSoundEffectVolume = this.client.getPreferences().getAreaSoundEffectVolume();
        });
    }

    private void loadOptions() {
        this.muteMusic = this.config.muteMusic();
        this.muteSoundEffects = this.config.muteSoundEffects();
        this.muteAreaSounds = this.config.muteAreaSounds();
    }

    private void refreshMutes() {
        if (!this.muteMusic) {
            this.clientThread.invoke(() -> this.client.setMusicVolume(this.initialMusicVolume));
        } else {
            this.clientThread.invoke(() -> {
                this.musicVolume = this.client.getMusicVolume();
                this.client.setMusicVolume(0);
            });
        }
        if (!this.muteSoundEffects) {
            this.client.getPreferences().setSoundEffectVolume(this.initialSoundEffectVolume);
        } else {
            this.clientThread.invoke(() -> {
                this.soundEffectVolume = this.client.getPreferences().getSoundEffectVolume();
                this.client.getPreferences().setSoundEffectVolume(0);
            });
        }
        if (!this.muteAreaSounds) {
            this.client.getPreferences().setAreaSoundEffectVolume(this.initialAreaSoundEffectVolume);
        } else {
            this.clientThread.invoke(() -> {
                this.soundEffectVolume = this.client.getPreferences().getAreaSoundEffectVolume();
                this.client.getPreferences().setAreaSoundEffectVolume(0);
            });
        }
    }

    @Subscribe
    public void onFocusChanged(FocusChanged focusChanged) {
        if (focusChanged.isFocused()) {
            this.clientThread.invoke(() -> {
                if (this.muteMusic) {
                    this.client.setMusicVolume(this.musicVolume);
                }
                if (this.muteSoundEffects) {
                    this.client.getPreferences().setSoundEffectVolume(this.soundEffectVolume);
                }
                if (this.muteAreaSounds) {
                    this.client.getPreferences().setAreaSoundEffectVolume(this.areaSoundEffectVolume);
                }
            });
        } else {
            this.clientThread.invoke(() -> {
                if (this.muteMusic) {
                    this.musicVolume = this.client.getMusicVolume();
                    this.client.setMusicVolume(0);
                }
                if (this.muteSoundEffects) {
                    this.soundEffectVolume = this.client.getPreferences().getSoundEffectVolume();
                    this.client.getPreferences().setSoundEffectVolume(0);
                }
                if (this.muteAreaSounds) {
                    this.areaSoundEffectVolume = this.client.getPreferences().getAreaSoundEffectVolume();
                    this.client.getPreferences().setAreaSoundEffectVolume(0);
                }
            });
        }
    }

    @Provides
    FocusMuteConfig provideConfig(ConfigManager configManager) {
        return (FocusMuteConfig)configManager.getConfig(FocusMuteConfig.class);
    }
}

