/*
 * Decompiled with CFR 0.152.
 */
package com.trevor.traynotifications;

import com.google.inject.Provides;
import com.trevor.traynotifications.CustomNotification;
import com.trevor.traynotifications.RlTrayNotificationsConfig;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.TrayIcon;
import javax.inject.Inject;
import javax.inject.Named;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NotificationFired;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="RL Tray Notifications")
public class RlTrayNotificationsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RlTrayNotificationsPlugin.class);
    @Inject
    private RlTrayNotificationsConfig config;
    @Inject
    private ClientUI clientUI;
    @Inject
    private RuneLiteConfig runeLiteConfig;
    @Inject
    private Client client;
    @Inject
    @Named(value="runelite.title")
    private String appName;

    @Subscribe
    public void onNotificationFired(NotificationFired event) {
        if (!this.runeLiteConfig.sendNotificationsWhenFocused() && this.clientUI.isFocused()) {
            return;
        }
        String title = this.client.getLocalPlayer() != null && this.client.getLocalPlayer().getName() != null ? this.client.getLocalPlayer().getName() : this.appName;
        SwingUtilities.invokeLater(() -> this.sendCustomNotification(title, event.getMessage(), event.getType()));
    }

    private void sendCustomNotification(String title, String message, TrayIcon.MessageType type) {
        GraphicsConfiguration graphicsConfiguration;
        if (this.config.monitor() == MonitorConfig.CURRENT_MONITOR) {
            graphicsConfiguration = this.clientUI.getGraphicsConfiguration();
        } else {
            GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice device = environment.getDefaultScreenDevice();
            graphicsConfiguration = device.getDefaultConfiguration();
        }
        CustomNotification.sendCustomNotification(title, message, graphicsConfiguration.getBounds(), this.config.corner(), this.config.expireTime());
    }

    @Provides
    RlTrayNotificationsConfig provideConfig(ConfigManager configManager) {
        return (RlTrayNotificationsConfig)configManager.getConfig(RlTrayNotificationsConfig.class);
    }

    public static enum CornerConfig {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }

    public static enum MonitorConfig {
        CURRENT_MONITOR,
        MAIN_MONITOR;

    }
}

