/*
 * Decompiled with CFR 0.152.
 */
package com.trevor.traynotifications;

import com.trevor.traynotifications.RlTrayNotificationsPlugin;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.util.ImageUtil;

class CustomNotification {
    private static final int WIDTH = 360;
    private static final int HEIGHT = 100;
    private static final int PADDING = 50;
    private static final double ANIMATION_LENGTH_SECONDS = 2.0;
    private static final double ANIMATION_MAX_LUM = 0.5;
    private static final BufferedImage RUNELITE_ICON = ImageUtil.getResourceStreamFromClass(RlTrayNotificationsPlugin.class, (String)"/util/runelite100.png");

    CustomNotification() {
    }

    static void sendCustomNotification(String title, String message, Rectangle display, RlTrayNotificationsPlugin.CornerConfig cornerConfig, int expireTime) {
        final JFrame window = new JFrame();
        window.setIconImage(ClientUI.ICON);
        window.setUndecorated(true);
        window.setFocusableWindowState(false);
        window.setAlwaysOnTop(true);
        CustomNotification.fullySaturateColors(window);
        int x = cornerConfig == RlTrayNotificationsPlugin.CornerConfig.BOTTOM_LEFT || cornerConfig == RlTrayNotificationsPlugin.CornerConfig.TOP_LEFT ? 50 : display.x + display.width - 360 - 50;
        int y = cornerConfig == RlTrayNotificationsPlugin.CornerConfig.TOP_RIGHT || cornerConfig == RlTrayNotificationsPlugin.CornerConfig.TOP_LEFT ? 50 : display.y + display.height - 100 - 50;
        window.setBounds(x, y, 360, 100);
        float[] hsbs = new float[3];
        Color stock = window.getContentPane().getBackground();
        Color.RGBtoHSB(stock.getRed(), stock.getGreen(), stock.getBlue(), hsbs);
        long start = System.currentTimeMillis();
        final Timer anim = new Timer(20, e -> {
            double seconds = (double)(System.currentTimeMillis() - start) / 1000.0;
            if (seconds > 2.0) {
                ((Timer)e.getSource()).stop();
                window.getContentPane().setBackground(stock);
                return;
            }
            double lumLevel = Math.sin(seconds / 2.0 * Math.PI);
            float lum = (float)(lumLevel * (0.5 - (double)hsbs[2]) + (double)hsbs[2]);
            window.getContentPane().setBackground(new Color(Color.HSBtoRGB(hsbs[0], hsbs[1], lum)));
        });
        anim.setRepeats(true);
        anim.start();
        final Timer closeTimer = new Timer(expireTime, e -> {
            anim.stop();
            window.setVisible(false);
            window.dispose();
        });
        closeTimer.start();
        window.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                anim.stop();
                closeTimer.stop();
                window.setVisible(false);
                window.dispose();
            }
        });
        JLabel iconLabel = new JLabel(new ImageIcon(RUNELITE_ICON));
        JLabel titleLabel = new JLabel(title);
        titleLabel.setFont(new Font("SansSerif", 1, 14));
        JLabel messageLabel = new JLabel("<html>" + message + "</html>");
        messageLabel.setFont(new Font("SansSerif", 0, 14));
        GroupLayout layout = new GroupLayout(window.getContentPane());
        window.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(iconLabel).addGroup(layout.createParallelGroup().addComponent(titleLabel).addComponent(messageLabel)));
        layout.setVerticalGroup(layout.createParallelGroup().addComponent(iconLabel).addGroup(layout.createSequentialGroup().addGap(8).addComponent(titleLabel).addGap(4).addComponent(messageLabel)));
        window.revalidate();
        window.setVisible(true);
    }

    public static void fullySaturateColors(JFrame window) {
        ((JPanel)window.getContentPane()).putClientProperty("substancelaf.internal.colorizationFactor", 1.0);
    }
}

