/*
 * Decompiled with CFR 0.152.
 */
package com.cluejuggling;

import com.cluejuggling.ClueScrollJugglingPlugin;
import com.cluejuggling.GroundItem;
import com.cluejuggling.LootType;
import com.google.common.collect.EvictingQueue;
import java.time.Duration;
import java.time.Instant;
import java.util.Queue;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.MenuAction;
import net.runelite.api.Tile;
import net.runelite.api.TileItem;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.eventbus.Subscribe;

public class GroundItemPluginStuff {
    private static final Duration DESPAWN_TIME_INSTANCE = Duration.ofMinutes(30L);
    private static final Duration DESPAWN_TIME_LOOT = Duration.ofMinutes(2L);
    private static final Duration DESPAWN_TIME_DROP = Duration.ofMinutes(3L);
    private static final Duration DESPAWN_TIME_TABLE = Duration.ofMinutes(10L);
    private static final int KRAKEN_REGION = 9116;
    private static final int KBD_NMZ_REGION = 9033;
    private static final int ZILYANA_REGION = 11602;
    private static final int GRAARDOR_REGION = 11347;
    private static final int KRIL_TSUTSAROTH_REGION = 11603;
    private static final int KREEARRA_REGION = 11346;
    private static final int NIGHTMARE_REGION = 15515;
    @Inject
    private ClueScrollJugglingPlugin plugin;
    private final Queue<Integer> droppedItemQueue = EvictingQueue.create((int)16);
    private int lastUsedItem;

    public GroundItemPluginStuff(ClueScrollJugglingPlugin plugin) {
        this.plugin = plugin;
    }

    Instant calculateDespawnTime(GroundItem groundItem) {
        Instant despawnTime;
        if (groundItem.getLootType() != LootType.PVM && groundItem.getLootType() != LootType.DROPPED && groundItem.getLootType() != LootType.TABLE) {
            return null;
        }
        Instant spawnTime = groundItem.getSpawnTime();
        if (spawnTime == null) {
            return null;
        }
        Instant now = Instant.now();
        if (this.plugin.client.isInInstancedRegion()) {
            int playerRegionID = WorldPoint.fromLocalInstance((Client)this.plugin.client, (LocalPoint)this.plugin.client.getLocalPlayer().getLocalLocation()).getRegionID();
            if (playerRegionID == 9116) {
                return null;
            }
            if (playerRegionID == 9033) {
                if (this.plugin.client.getLocalPlayer().getWorldLocation().getPlane() == 0) {
                    despawnTime = spawnTime.plus(groundItem.getLootType() == LootType.DROPPED ? DESPAWN_TIME_DROP : DESPAWN_TIME_LOOT);
                } else {
                    if (groundItem.getLootType() == LootType.DROPPED) {
                        return null;
                    }
                    despawnTime = spawnTime.plus(DESPAWN_TIME_LOOT);
                }
            } else {
                despawnTime = playerRegionID == 11602 || playerRegionID == 11347 || playerRegionID == 11603 || playerRegionID == 11346 || playerRegionID == 15515 ? spawnTime.plus(groundItem.getLootType() == LootType.DROPPED ? DESPAWN_TIME_DROP : DESPAWN_TIME_LOOT) : spawnTime.plus(DESPAWN_TIME_INSTANCE);
            }
        } else {
            switch (groundItem.getLootType()) {
                case DROPPED: {
                    despawnTime = spawnTime.plus(DESPAWN_TIME_DROP);
                    break;
                }
                case TABLE: {
                    despawnTime = spawnTime.plus(DESPAWN_TIME_TABLE);
                    break;
                }
                default: {
                    despawnTime = spawnTime.plus(DESPAWN_TIME_LOOT);
                }
            }
        }
        if (now.isBefore(spawnTime) || now.isAfter(despawnTime)) {
            return null;
        }
        return despawnTime;
    }

    GroundItem buildGroundItem(Tile tile, TileItem item) {
        int itemId = item.getId();
        ItemComposition itemComposition = this.plugin.itemManager.getItemComposition(itemId);
        int realItemId = itemComposition.getNote() != -1 ? itemComposition.getLinkedNoteId() : itemId;
        int alchPrice = itemComposition.getHaPrice();
        boolean dropped = tile.getWorldLocation().equals((Object)this.plugin.client.getLocalPlayer().getWorldLocation()) && this.droppedItemQueue.remove(itemId);
        boolean table = itemId == this.lastUsedItem && tile.getItemLayer().getHeight() > 0;
        GroundItem groundItem = GroundItem.builder().id(itemId).location(tile.getWorldLocation()).itemId(realItemId).quantity(item.getQuantity()).name(itemComposition.getName()).haPrice(alchPrice).height(tile.getItemLayer().getHeight()).tradeable(itemComposition.isTradeable()).lootType(dropped ? LootType.DROPPED : (table ? LootType.TABLE : LootType.UNKNOWN)).spawnTime(Instant.now()).stackable(itemComposition.isStackable()).build();
        return groundItem;
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked menuOptionClicked) {
        if (menuOptionClicked.isItemOp() && menuOptionClicked.getMenuOption().equals("Drop")) {
            int itemId = menuOptionClicked.getItemId();
            this.droppedItemQueue.add(itemId);
        } else if (menuOptionClicked.getMenuAction() == MenuAction.WIDGET_TARGET_ON_GAME_OBJECT && this.plugin.client.getSelectedWidget().getId() == WidgetInfo.INVENTORY.getId()) {
            this.lastUsedItem = this.plugin.client.getSelectedWidget().getItemId();
        }
    }

    public void startUp() {
        this.lastUsedItem = -1;
    }
}

