/*
 * Decompiled with CFR 0.152.
 */
package com.cluejuggling;

import com.cluejuggling.ClueScrollJugginglingConfig;
import com.cluejuggling.GroundItem;
import com.cluejuggling.GroundItemPluginStuff;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.Tile;
import net.runelite.api.TileItem;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.ItemSpawned;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.ui.overlay.infobox.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Clue Juggling Timers", description="clue despawn timers", tags={"clue", "juggling", "timer", "despawn"})
public class ClueScrollJugglingPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ClueScrollJugglingPlugin.class);
    @Inject
    Client client;
    @Inject
    ItemManager itemManager;
    @Inject
    private ClueScrollJugginglingConfig config;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private EventBus eventBus;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Notifier notifier;
    private GroundItemPluginStuff groundItemPluginStuff = new GroundItemPluginStuff(this);
    public Map<GroundItem.GroundItemKey, Timer> dropTimers = new HashMap<GroundItem.GroundItemKey, Timer>();
    private Set<GroundItem.GroundItemKey> alreadyNotified = new HashSet<GroundItem.GroundItemKey>();

    @Provides
    public ClueScrollJugginglingConfig getConfig(ConfigManager configManager) {
        return (ClueScrollJugginglingConfig)configManager.getConfig(ClueScrollJugginglingConfig.class);
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        TileItem item = itemSpawned.getItem();
        ItemComposition itemComposition = this.itemManager.getItemComposition(item.getId());
        ClueTier clueTier = ClueTier.getClueTier(itemComposition.getName());
        if (clueTier == null || !clueTier.showTimers(this.config)) {
            return;
        }
        Tile tile = itemSpawned.getTile();
        GroundItem.GroundItemKey groundItemKey = new GroundItem.GroundItemKey(item.getId(), tile.getWorldLocation());
        if (!this.dropTimers.containsKey(groundItemKey)) {
            Instant instant = this.groundItemPluginStuff.calculateDespawnTime(this.groundItemPluginStuff.buildGroundItem(tile, item));
            instant.compareTo(Instant.now());
            Duration between = Duration.between(Instant.now(), instant);
            Timer timer = new Timer(between.getSeconds(), ChronoUnit.SECONDS, (BufferedImage)this.itemManager.getImage(item.getId()), this){

                public Color getTextColor() {
                    return ClueScrollJugglingPlugin.this.showNotifications() && Duration.between(Instant.now(), this.getEndTime()).compareTo(Duration.ofSeconds(ClueScrollJugglingPlugin.this.config.notificationTime())) < 0 ? Color.RED : super.getTextColor();
                }
            };
            this.infoBoxManager.addInfoBox((InfoBox)timer);
            this.alreadyNotified.remove(groundItemKey);
            this.dropTimers.put(groundItemKey, timer);
        }
    }

    private boolean showNotifications() {
        return this.config.notificationTime() > 0;
    }

    @Subscribe
    public void onItemDespawned(ItemDespawned itemDespawned) {
        TileItem item = itemDespawned.getItem();
        ItemComposition itemComposition = this.itemManager.getItemComposition(item.getId());
        if (!itemComposition.getName().toLowerCase().contains("clue scroll")) {
            return;
        }
        Tile tile = itemDespawned.getTile();
        GroundItem.GroundItemKey groundItemKey = new GroundItem.GroundItemKey(item.getId(), tile.getWorldLocation());
        Timer removedTimer = this.dropTimers.remove(groundItemKey);
        this.infoBoxManager.removeInfoBox((InfoBox)removedTimer);
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        for (Map.Entry<GroundItem.GroundItemKey, Timer> groundItemKeyTimerEntry : this.dropTimers.entrySet()) {
            GroundItem.GroundItemKey groundItemKey = groundItemKeyTimerEntry.getKey();
            Timer timer = groundItemKeyTimerEntry.getValue();
            if (!this.showNotifications() || Duration.between(Instant.now(), timer.getEndTime()).compareTo(Duration.ofSeconds(this.config.notificationTime())) >= 0 || this.alreadyNotified.contains(groundItemKey)) continue;
            timer.getTextColor();
            this.notifier.notify("Your clue scroll is about to disappear!");
            this.alreadyNotified.add(groundItemKey);
        }
    }

    protected void startUp() {
        this.eventBus.register((Object)this.groundItemPluginStuff);
        this.groundItemPluginStuff.startUp();
    }

    protected void shutDown() {
        this.eventBus.unregister((Object)this.groundItemPluginStuff);
    }

    static enum ClueTier {
        BEGINNER(config -> config.beginnerTimers()),
        EASY(config -> config.easyTimers()),
        MEDIUM(config -> config.mediumTimers()),
        HARD(config -> config.hardTimers()),
        ELITE(config -> config.eliteTimers()),
        MASTER(config -> config.masterTimers());

        private final Predicate<ClueScrollJugginglingConfig> showTimer;

        public static ClueTier getClueTier(String clueName) {
            return clueName.equals("Clue scroll (beginner)") ? BEGINNER : (clueName.equals("Clue scroll (easy)") ? EASY : (clueName.equals("Clue scroll (medium)") ? MEDIUM : (clueName.equals("Clue scroll (hard)") ? HARD : (clueName.equals("Clue scroll (elite)") ? ELITE : (clueName.equals("Clue scroll (master)") ? MASTER : null)))));
        }

        public boolean showTimers(ClueScrollJugginglingConfig config) {
            return this.showTimer.test(config);
        }

        private ClueTier(Predicate<ClueScrollJugginglingConfig> showTimer) {
            this.showTimer = showTimer;
        }
    }
}

