/*
 * Decompiled with CFR 0.152.
 */
package bbp.chambers;

import bbp.chambers.CoxScouterExternalConfig;
import bbp.chambers.CoxScouterExternalOverlay;
import bbp.chambers.CoxScouterExternalTutorialOverlay;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.OverlayMenuClicked;
import net.runelite.client.game.ItemManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.party.PartyMember;
import net.runelite.client.party.PartyService;
import net.runelite.client.party.messages.PartyChatMessage;
import net.runelite.client.party.messages.PartyMessage;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.raids.Raid;
import net.runelite.client.plugins.raids.RaidRoom;
import net.runelite.client.plugins.raids.RoomType;
import net.runelite.client.plugins.raids.events.RaidReset;
import net.runelite.client.plugins.raids.events.RaidScouted;
import net.runelite.client.plugins.raids.solver.Room;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.ImageCapture;
import net.runelite.client.util.ImageUploadStyle;
import net.runelite.client.util.Text;
import net.runelite.http.api.item.ItemPrice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="CoX Scouter External", tags={"combat", "overlay", "pve", "pvm", "bosses", "chambers", "xeric", "raids"})
public class CoxScouterExternalPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CoxScouterExternalPlugin.class);
    private Raid raid;
    @Inject
    private Client client;
    @Inject
    private RuneLiteConfig runeLiteConfig;
    @Inject
    private ImageCapture imageCapture;
    @Inject
    private CoxScouterExternalConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private CoxScouterExternalOverlay overlay;
    @Inject
    private CoxScouterExternalTutorialOverlay tutorialOverlay;
    @Inject
    private ItemManager itemManager;
    @Inject
    private PartyService party;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ClientThread clientThread;
    private final Set<String> roomWhitelist = new HashSet<String>();
    private final Set<String> roomBlacklist = new HashSet<String>();
    private final Set<String> rotationWhitelist = new HashSet<String>();
    private final Set<String> layoutWhitelist = new HashSet<String>();
    private final Set<String> roomHighlightedList = new HashSet<String>();
    private final Map<String, List<Integer>> recommendedItemsList = new HashMap<String, List<Integer>>();
    private int raidPartyID;
    private boolean shouldShowOverlays;
    private boolean inRaidChambers;
    private static int raidState;
    private static final Pattern ROTATION_REGEX;
    private static final int OLM_PLANE = 0;
    private final HotkeyListener screenshotHotkeyListener = new HotkeyListener(() -> this.config.screenshotHotkey()){

        public void hotkeyPressed() {
            CoxScouterExternalPlugin.this.clientThread.invoke(() -> CoxScouterExternalPlugin.this.screenshotScoutOverlay());
        }
    };

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.tutorialOverlay);
        this.updateLists();
        this.clientThread.invokeLater(this::checkRaidPresence);
        this.keyManager.registerKeyListener((KeyListener)this.screenshotHotkeyListener);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.tutorialOverlay);
        this.inRaidChambers = false;
        this.keyManager.unregisterKeyListener((KeyListener)this.screenshotHotkeyListener);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("raids") && !event.getGroup().equals("coxscouterexternal")) {
            return;
        }
        this.updateLists();
    }

    @Subscribe
    public void onRaidScouted(RaidScouted raidScouted) {
        this.raid = raidScouted.getRaid();
    }

    @Subscribe
    public void onRaidReset(RaidReset raidReset) {
        this.raid = null;
    }

    @Subscribe
    public void onOverlayMenuClicked(OverlayMenuClicked event) {
        if (event.getEntry().getMenuAction() != MenuAction.RUNELITE_OVERLAY || event.getOverlay() != this.overlay) {
            return;
        }
        if (event.getEntry().getOption().equals("Broadcast layout")) {
            this.sendRaidLayoutMessage();
        } else if (event.getEntry().getOption().equals("Screenshot")) {
            this.clientThread.invoke(this::screenshotScoutOverlay);
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        this.clientThread.invokeLater(this::checkRaidPresence);
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        this.shouldShowOverlays = this.shouldShowOverlays();
    }

    @Provides
    CoxScouterExternalConfig provideConfig(ConfigManager configManager) {
        return (CoxScouterExternalConfig)configManager.getConfig(CoxScouterExternalConfig.class);
    }

    @VisibleForTesting
    private void updateLists() {
        this.updateList(this.roomWhitelist, this.configManager.getConfiguration("raids", "whitelistedRooms"));
        this.updateList(this.roomBlacklist, this.configManager.getConfiguration("raids", "blacklistedRooms"));
        this.updateList(this.layoutWhitelist, this.configManager.getConfiguration("raids", "whitelistedLayouts"));
        this.updateList(this.roomHighlightedList, this.config.highlightedRooms());
        this.updateMap(this.recommendedItemsList, this.config.recommendedItems());
        this.rotationWhitelist.clear();
        if (this.configManager.getConfiguration("raids", "whitelistedRotations") != null) {
            for (String line : this.configManager.getConfiguration("raids", "whitelistedRotations").split("\\n")) {
                this.rotationWhitelist.add(line.toLowerCase().replace(" ", ""));
            }
        }
    }

    private void updateList(Collection<String> list, String input) {
        if (input == null) {
            return;
        }
        list.clear();
        for (String s : Text.fromCSV((String)input.toLowerCase())) {
            if (s.equals("unknown")) {
                list.add("unknown (combat)");
                list.add("unknown (puzzle)");
                continue;
            }
            list.add(s);
        }
    }

    private void updateMap(Map<String, List<Integer>> map, String input) {
        map.clear();
        Matcher m = ROTATION_REGEX.matcher(input);
        while (m.find()) {
            String key;
            String everything = m.group(1).toLowerCase();
            int split = everything.indexOf(44);
            if (split < 0 || (key = everything.substring(0, split)).length() < 1) continue;
            List itemNames = Text.fromCSV((String)everything.substring(split));
            map.computeIfAbsent(key, k -> new ArrayList());
            for (String itemName : itemNames) {
                if (itemName.equals("")) continue;
                if (itemName.equals("ice barrage")) {
                    map.get(key).add(328);
                    continue;
                }
                if (itemName.startsWith("salve")) {
                    map.get(key).add(12018);
                    continue;
                }
                if (itemName.contains("blowpipe")) {
                    map.get(key).add(12926);
                    continue;
                }
                if (this.itemManager.search(itemName).size() > 0) {
                    map.get(key).add(((ItemPrice)this.itemManager.search(itemName).get(0)).getId());
                    continue;
                }
                log.info("RaidsPlugin: Could not find an item ID for item: " + itemName);
            }
        }
    }

    boolean getRotationMatches() {
        RaidRoom[] combatRooms = this.getCombatRooms();
        String rotation = Arrays.stream(combatRooms).map(RaidRoom::getName).map(String::toLowerCase).collect(Collectors.joining(","));
        return this.rotationWhitelist.contains(rotation);
    }

    private RaidRoom[] getCombatRooms() {
        ArrayList<RaidRoom> combatRooms = new ArrayList<RaidRoom>();
        for (Room room : this.raid.getLayout().getRooms()) {
            if (room == null || this.raid.getRooms()[room.getPosition()].getType() != RoomType.COMBAT) continue;
            combatRooms.add(this.raid.getRooms()[room.getPosition()]);
        }
        return combatRooms.toArray(new RaidRoom[0]);
    }

    private void sendRaidLayoutMessage() {
        String layout = this.getRaid().getLayout().toCodeString();
        String rooms = this.toRoomString(this.getRaid());
        String raidData = "[" + layout + "]: " + rooms;
        String layoutMessage = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("Layout: ").append(ChatColorType.NORMAL).append(raidData).build();
        PartyMember localMember = this.party.getLocalMember();
        if (this.party.getMembers().isEmpty() || localMember == null) {
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.FRIENDSCHATNOTIFICATION).runeLiteFormattedMessage(layoutMessage).build());
        } else {
            PartyChatMessage message = new PartyChatMessage(layoutMessage);
            message.setMemberId(localMember.getMemberId());
            this.party.send((PartyMessage)message);
        }
    }

    private String toRoomString(Raid raid) {
        StringBuilder sb = new StringBuilder();
        for (RaidRoom room : this.getOrderedRooms(raid)) {
            switch (room.getType()) {
                case PUZZLE: 
                case COMBAT: {
                    sb.append(room.getName()).append(", ");
                }
            }
        }
        String roomsString = sb.toString();
        return roomsString.substring(0, roomsString.length() - 2);
    }

    private List<RaidRoom> getOrderedRooms(Raid raid) {
        ArrayList<RaidRoom> orderedRooms = new ArrayList<RaidRoom>();
        for (Room r : raid.getLayout().getRooms()) {
            int position = r.getPosition();
            RaidRoom room = raid.getRoom(position);
            if (room == null) continue;
            orderedRooms.add(room);
        }
        return orderedRooms;
    }

    private void screenshotScoutOverlay() {
        if (!this.shouldShowOverlays) {
            return;
        }
        Rectangle overlayDimensions = this.overlay.getBounds();
        BufferedImage overlayImage = new BufferedImage(overlayDimensions.width, overlayDimensions.height, 1);
        Graphics2D graphic = overlayImage.createGraphics();
        graphic.setFont(this.runeLiteConfig.interfaceFontType().getFont());
        graphic.setColor(Color.BLACK);
        graphic.fillRect(0, 0, overlayDimensions.width, overlayDimensions.height);
        this.overlay.render(graphic);
        this.imageCapture.takeScreenshot(overlayImage, "CoX_scout-", false, (ImageUploadStyle)this.configManager.getConfiguration("raids", "uploadScreenshot", ImageUploadStyle.class));
        graphic.dispose();
    }

    boolean shouldShowOverlays() {
        if (this.raid == null || this.raid.getLayout() == null || !this.config.scoutOverlay()) {
            return false;
        }
        if (this.isInRaidChambers()) {
            if (raidState > 0) {
                if (this.client.getPlane() == 0) {
                    return false;
                }
                return (Boolean)this.configManager.getConfiguration("raids", "scoutOverlayInRaid", Boolean.class);
            }
            return true;
        }
        Boolean overlayAtBank = (Boolean)this.configManager.getConfiguration("raids", "scoutOverlayAtBank", Boolean.class);
        return this.getRaidPartyID() != -1 && overlayAtBank != false;
    }

    private void checkRaidPresence() {
        boolean tempInRaid;
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        int tempRaidState = this.client.getVarbitValue(5425);
        int tempPartyID = this.client.getVar(1427);
        boolean bl = tempInRaid = this.client.getVarbitValue(5432) == 1;
        if (tempPartyID != this.raidPartyID) {
            this.raidPartyID = tempPartyID;
        }
        if (tempInRaid != this.inRaidChambers) {
            this.inRaidChambers = tempInRaid;
        }
        if (tempRaidState != raidState) {
            raidState = tempRaidState;
        }
    }

    public Raid getRaid() {
        return this.raid;
    }

    public Set<String> getRoomWhitelist() {
        return this.roomWhitelist;
    }

    public Set<String> getRoomBlacklist() {
        return this.roomBlacklist;
    }

    public Set<String> getRotationWhitelist() {
        return this.rotationWhitelist;
    }

    public Set<String> getLayoutWhitelist() {
        return this.layoutWhitelist;
    }

    public Set<String> getRoomHighlightedList() {
        return this.roomHighlightedList;
    }

    public Map<String, List<Integer>> getRecommendedItemsList() {
        return this.recommendedItemsList;
    }

    public int getRaidPartyID() {
        return this.raidPartyID;
    }

    public boolean isShouldShowOverlays() {
        return this.shouldShowOverlays;
    }

    public boolean isInRaidChambers() {
        return this.inRaidChambers;
    }

    static {
        ROTATION_REGEX = Pattern.compile("\\[(.*?)]");
    }
}

