/*
 * Decompiled with CFR 0.152.
 */
package bbp.chambers;

import bbp.chambers.CoxScouterExternalConfig;
import bbp.chambers.CoxScouterExternalPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.FriendsChatManager;
import net.runelite.api.MenuAction;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.game.WorldService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.raids.RaidRoom;
import net.runelite.client.plugins.raids.solver.Room;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import net.runelite.client.util.ImageUtil;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldRegion;
import net.runelite.http.api.worlds.WorldResult;

public class CoxScouterExternalOverlay
extends OverlayPanel {
    static final String BROADCAST_ACTION = "Broadcast layout";
    static final String SCREENSHOT_ACTION = "Screenshot";
    private static final int BORDER_OFFSET = 2;
    private static final int ICON_SIZE = 32;
    private static final int SMALL_ICON_SIZE = 21;
    private final Client client;
    private final CoxScouterExternalPlugin plugin;
    private final CoxScouterExternalConfig config;
    private final ItemManager itemManager;
    private final SpriteManager spriteManager;
    private final PanelComponent panelImages = new PanelComponent();
    @Inject
    private WorldService worldService;
    @Inject
    private ConfigManager configManager;

    @Inject
    private CoxScouterExternalOverlay(Client client, CoxScouterExternalPlugin plugin, CoxScouterExternalConfig config, ItemManager itemManager, SpriteManager spriteManager) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.LOW);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.itemManager = itemManager;
        this.spriteManager = spriteManager;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Raids overlay"));
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, BROADCAST_ACTION, "Raids overlay"));
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, SCREENSHOT_ACTION, "Raids overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        String displayLayout;
        String layout;
        this.plugin.shouldShowOverlays();
        if (!this.plugin.isShouldShowOverlays()) {
            return null;
        }
        Boolean ccDisplay = (Boolean)this.configManager.getConfiguration("raids", "ccDisplay", Boolean.class);
        Boolean enabledWhitelist = (Boolean)this.configManager.getConfiguration("raids", "enableLayoutWhitelist", Boolean.class);
        Boolean rotationWhitelist = (Boolean)this.configManager.getConfiguration("raids", "enableRotationWhitelist", Boolean.class);
        Color color = Color.WHITE;
        try {
            layout = this.plugin.getRaid().getLayout().toCodeString();
        }
        catch (NullPointerException e) {
            layout = "";
        }
        FontMetrics metrics = graphics.getFontMetrics();
        if (this.config.displayFloorBreak()) {
            displayLayout = this.plugin.getRaid().getLayout().toCode();
            displayLayout = displayLayout.substring(0, displayLayout.length() - 1).replaceAll("#", "").replaceFirst("\u00a4", " | ");
        } else {
            displayLayout = layout;
        }
        if (enabledWhitelist.booleanValue() && !this.plugin.getLayoutWhitelist().contains(layout.toLowerCase())) {
            color = Color.RED;
        }
        boolean hide = false;
        HashSet<String> roomNames = new HashSet<String>();
        for (Object layoutRoom : this.plugin.getRaid().getLayout().getRooms()) {
            int position = layoutRoom.getPosition();
            RaidRoom room = this.plugin.getRaid().getRoom(position);
            if (room == null) continue;
            roomNames.add(room.getName().toLowerCase());
            if (!this.config.hideBlacklisted() || !this.plugin.getRoomBlacklist().contains(room.getName().toLowerCase())) continue;
            hide = true;
            break;
        }
        if (!hide) {
            if (this.config.hideMissingHighlighted()) {
                int hCount = 0;
                for (String requiredRoom : this.plugin.getRoomHighlightedList()) {
                    if (!roomNames.contains(requiredRoom)) continue;
                    ++hCount;
                }
                if (hCount < this.config.highlightedShowThreshold()) {
                    hide = true;
                }
            }
            if (this.config.hideMissingLayout() && enabledWhitelist.booleanValue() && !this.plugin.getLayoutWhitelist().contains(layout.toLowerCase())) {
                hide = true;
            }
            if (this.config.hideRopeless() && !roomNames.contains("tightrope")) {
                hide = true;
            }
        }
        if (hide) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text("Bad Raid!").color(Color.RED).build());
            return super.render(graphics);
        }
        this.panelComponent.getChildren().add(TitleComponent.builder().text(displayLayout).color(color).build());
        if (ccDisplay.booleanValue()) {
            World world;
            WorldRegion region;
            color = Color.RED;
            FriendsChatManager friendsChatManager = this.client.getFriendsChatManager();
            String worldString = "W" + this.client.getWorld();
            WorldResult worldResult = this.worldService.getWorlds();
            if (worldResult != null && (region = (world = worldResult.findWorld(this.client.getWorld())).getRegion()) != null) {
                String countryCode = region.getAlpha2();
                worldString = worldString + " (" + countryCode + ")";
            }
            Object owner = "Join a FC";
            if (friendsChatManager != null) {
                owner = friendsChatManager.getOwner();
                color = Color.ORANGE;
            }
            this.panelComponent.setPreferredSize(new Dimension(Math.max(129, metrics.stringWidth(worldString) + metrics.stringWidth((String)owner) + 14), 0));
            this.panelComponent.getChildren().add(LineComponent.builder().left(worldString).right((String)owner).leftColor(Color.ORANGE).rightColor(color).build());
        }
        HashSet imageIds = new HashSet();
        int roomWidth = 0;
        for (Room layoutRoom : this.plugin.getRaid().getLayout().getRooms()) {
            int position = layoutRoom.getPosition();
            RaidRoom room = this.plugin.getRaid().getRoom(position);
            if (room == null) continue;
            int temp = metrics.stringWidth(room.getName());
            if (temp > roomWidth) {
                roomWidth = temp;
            }
            color = Color.WHITE;
            switch (room.getType()) {
                case COMBAT: {
                    String bossName = room == RaidRoom.UNKNOWN_COMBAT ? "Unknown" : room.getName();
                    String bossNameLC = room.getName().toLowerCase();
                    if (this.config.showRecommendedItems() && this.plugin.getRecommendedItemsList().get(bossNameLC) != null) {
                        imageIds.addAll(this.plugin.getRecommendedItemsList().get(bossNameLC));
                    }
                    if (this.plugin.getRoomHighlightedList().contains(bossNameLC) && !this.config.highlightColor().equals(Color.WHITE)) {
                        color = this.config.highlightColor();
                    } else if (this.plugin.getRoomWhitelist().contains(bossNameLC)) {
                        color = Color.GREEN;
                    } else if (this.plugin.getRoomBlacklist().contains(bossNameLC) || rotationWhitelist.booleanValue() && !this.plugin.getRotationMatches()) {
                        color = Color.RED;
                    }
                    this.panelComponent.getChildren().add(LineComponent.builder().left(this.config.showRecommendedItems() ? "" : room.getType().getName()).right(bossName).rightColor(color).build());
                    break;
                }
                case PUZZLE: {
                    String puzzleName = room == RaidRoom.UNKNOWN_PUZZLE ? "Unknown" : room.getName();
                    String puzzleNameLC = room.getName().toLowerCase();
                    if (this.config.showRecommendedItems() && this.plugin.getRecommendedItemsList().get(puzzleNameLC) != null) {
                        imageIds.addAll(this.plugin.getRecommendedItemsList().get(puzzleNameLC));
                    }
                    if (this.plugin.getRoomHighlightedList().contains(puzzleNameLC)) {
                        color = this.config.highlightColor();
                    } else if (this.plugin.getRoomWhitelist().contains(puzzleNameLC)) {
                        color = Color.GREEN;
                    } else if (this.plugin.getRoomBlacklist().contains(puzzleNameLC)) {
                        color = Color.RED;
                    }
                    this.panelComponent.getChildren().add(LineComponent.builder().left(this.config.showRecommendedItems() ? "" : room.getType().getName()).right(puzzleName).rightColor(color).build());
                }
            }
        }
        Dimension panelDims = super.render(graphics);
        if (this.config.showRecommendedItems() && imageIds.size() > 0) {
            this.panelImages.getChildren().clear();
            Integer[] idArray = imageIds.toArray(new Integer[0]);
            int fontHeight = metrics.getHeight();
            int imagesVerticalOffset = 4 + fontHeight + (ccDisplay != false ? fontHeight : 0);
            int imagesMaxHeight = (int)panelDims.getHeight() - 2 - imagesVerticalOffset;
            boolean smallImages = false;
            this.panelImages.setPreferredLocation(new Point(0, imagesVerticalOffset));
            this.panelImages.setBackgroundColor(null);
            this.panelImages.setWrap(true);
            this.panelImages.setPreferredSize(new Dimension(64, 0));
            if (2 * (imagesMaxHeight / 32) < idArray.length) {
                smallImages = true;
                this.panelImages.setPreferredSize(new Dimension(63, 0));
            }
            this.panelImages.setOrientation(ComponentOrientation.HORIZONTAL);
            for (Integer e : idArray) {
                BufferedImage image = this.getImage(e, smallImages);
                if (image == null) continue;
                this.panelImages.getChildren().add(new ImageComponent(image));
            }
            this.panelImages.render(graphics);
        }
        return panelDims;
    }

    private BufferedImage getImage(int id, boolean small) {
        Object bim = id != 328 ? this.itemManager.getImage(id) : this.spriteManager.getSprite(id, 0);
        if (bim == null) {
            return null;
        }
        if (!small) {
            return ImageUtil.resizeCanvas((BufferedImage)bim, (int)32, (int)32);
        }
        if (id != 328) {
            return ImageUtil.resizeImage((BufferedImage)bim, (int)21, (int)21);
        }
        return ImageUtil.resizeCanvas((BufferedImage)bim, (int)21, (int)21);
    }
}

