/*
 * Decompiled with CFR 0.152.
 */
package com.vengeancehelper;

import com.google.inject.Provides;
import com.vengeancehelper.VengeanceHelperConfig;
import com.vengeancehelper.VengeanceHelperOverlay;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Vengeance Helper")
public class VengeanceHelperPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(VengeanceHelperPlugin.class);
    @Inject
    private Client client;
    @Inject
    private Notifier notifier;
    @Inject
    private VengeanceHelperOverlay overlay;
    @Inject
    private VengeanceHelperConfig config;
    @Inject
    private OverlayManager overlayManager;
    private Instant overlayLastDisplayed;
    private static final int SPELLBOOK_VARBIT = 4070;
    private static final int LUNAR_SPELLBOOK = 2;

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
        this.clearOverlay();
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.config.onlyLunar() && this.client.getVarbitValue(4070) != 2) {
            this.clearOverlay();
        }
        if (this.overlayLastDisplayed != null) {
            Duration timeoutOverlay = Duration.ofSeconds(this.config.vengeanceTimeout());
            Duration sinceLastOverlayDisplay = Duration.between(this.overlayLastDisplayed, Instant.now());
            if (sinceLastOverlayDisplay.compareTo(timeoutOverlay) >= 0) {
                this.clearOverlay();
            }
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (event.getVarbitId() == 2450 || event.getVarbitId() == 2451) {
            boolean isVengeanceCastable;
            boolean isVengeanceActive = this.client.getVarbitValue(2450) == 1;
            boolean bl = isVengeanceCastable = this.client.getVarbitValue(2451) == 0;
            if (!isVengeanceActive && isVengeanceCastable) {
                if (this.config.onlyLunar() && this.client.getVarbitValue(4070) != 2) {
                    return;
                }
                this.overlayManager.add((Overlay)this.overlay);
                if (this.config.shouldNotify()) {
                    this.notifier.notify("You need to cast vengeance!");
                }
                this.overlayLastDisplayed = Instant.now();
            } else {
                this.clearOverlay();
            }
        }
    }

    public void clearOverlay() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayLastDisplayed = null;
    }

    @Provides
    VengeanceHelperConfig provideConfig(ConfigManager configManager) {
        return (VengeanceHelperConfig)configManager.getConfig(VengeanceHelperConfig.class);
    }
}

